% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{glossophobia}
\alias{glossophobia}
\title{Glossophobia survey}
\format{
A data frame with 139 rows (participants) and 41 columns (questions):
\itemize{
\item columns 1-25: descriptions of speaking in public
\item columns 26-41: personal information
}
}
\source{
Elina BIAU and Théo LEDAIN, students at l'Institut Agro Rennes-Angers
}
\usage{
glossophobia
}
\description{
These data were collected after a Q-method-like survey on participants' feelings about speaking in public.
Participants had to rank how much they agreed with 25 descriptions of speaking in public; then, they were asked personal questions.
}
\examples{
\donttest{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(glossophobia)

res_mca_phobia <- FactoMineR::MCA(glossophobia, quali.sup = 26:41,
level.ventil = 0.05, graph = FALSE)
phobia_work <- res_mca_phobia$ind$coord |> as.data.frame()
phobia_work <- phobia_work[,1] |> cbind(glossophobia)

intro_phobia <- "These data were collected after a survey
on participants' feelings about speaking in public.
Participants had to rank how much they agreed with
25 descriptions of speaking in public;
then, they were asked personal questions."
intro_phobia <- gsub('\n', ' ', intro_phobia) |>
stringr::str_squish()

res_phobia <- nail_condes(phobia_work, num.var = 1,
introduction = intro_phobia)
cat(res_phobia$response)
}
}
\keyword{datasets}
