% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.pred}
\alias{uTAR.pred}
\title{Prediction of A Fitted Univariate TAR Model}
\usage{
uTAR.pred(model, orig, h = 1, iterations = 3000, ci = 0.95,
  output = TRUE)
}
\arguments{
\item{model}{univariate TAR model.}

\item{orig}{forecast origin.}

\item{h}{forecast horizon.}

\item{iterations}{number of iterations.}

\item{ci}{confidence level.}

\item{output}{a logical value for output, default is TRUE.}
}
\value{
uTAR.pred returns a list with components:
\item{model}{univariate TAR model.}
\item{pred}{prediction.}
\item{Ysim}{fitted y.}
}
\description{
Prediction of a fitted univariate TAR model.
}
\examples{
arorder=rep(1,2)
ar.coef=matrix(c(0.7,-0.8),2,1)
y=uTAR.sim(100,arorder,ar.coef,1,0)
est=uTAR.est(y$series,arorder,0,1)
pred=uTAR.pred(est,100,1,100,0.95,TRUE)
}
