% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.est}
\alias{uTAR.est}
\title{General Estimation of TAR Models}
\usage{
uTAR.est(y, arorder = c(1, 1), thr = c(0), d = 1, thrV = NULL,
  include.mean = c(TRUE, TRUE), output = TRUE)
}
\arguments{
\item{y}{time series.}

\item{arorder}{AR order of each regime. The number of regime is the length of arorder.}

\item{thr}{given threshould(s). There are k-1 threshold for a k-regime model.}

\item{d}{delay for threshold variable, default is 1.}

\item{thrV}{external threhold variable if any. If it is not NULL, thrV must have the same length as that of y.}

\item{include.mean}{a logical value indicating whether constant terms are included. Default is TRUE.}

\item{output}{a logical value for output. Default is TRUE.}
}
\value{
uTAR.est returns a list with components:
\item{data}{the data matrix, y.}
\item{k}{the dimension of y.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{coefs}{a (p*k+1)-by-(2k) matrices. The first row show the estimation results in regime 1, and the second row shows these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{thr}{threshold value.}
\item{residuals}{estimated innovations.}
\item{sresi}{standardized residuals.}
\item{nobs}{numbers of observations in different regimes.}
\item{delay}{delay for threshold variable.}
\item{cnst}{logical values indicating whether the constant terms are included in different regimes.}
\item{AIC}{AIC value.}
}
\description{
General estimation of TAR models with known threshold values.
It perform LS estimation of a univariate TAR model, and can handle multiple regimes.
}
\examples{
arorder=rep(1,2)
ar.coef=matrix(c(0.7,-0.8),2,1)
y=uTAR.sim(100,arorder,ar.coef,1,0)
est=uTAR.est(y$series,arorder,0,1)
}
