% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{NNS_bin}
\alias{NNS_bin}
\title{Fast binning of numeric vector into equidistant bins}
\usage{
NNS_bin(x, width, origin = 0, missinglast = FALSE)
}
\arguments{
\item{x}{A matrix of regressor variables. Must have the same number of rows as the length of y.}

\item{width}{The width of the bins}

\item{origin}{The starting point for the bins. Any number smaller than origin will be disregarded}

\item{missinglast}{Boolean. Should the missing observations be added as a separate element at the end of the returned count vector.}
}
\value{
An list with elements counts (the frequencies), origin (the origin), width (the width), missing (the number of missings), and last_bin_is_missing (boolean) telling whether the missinglast is true or not.
}
\description{
Missing values (NA, Inf, NaN) are added at the end of the vector as the last bin returned if missinglast is set to TRUE
}
\examples{
\dontrun{
set.seed(1)
x <- sample(10, 20, replace = TRUE)
NNS_bin(x, 15)
}
}
