% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nowcast.R
\name{NNS.nowcast}
\alias{NNS.nowcast}
\title{NNS Nowcast}
\usage{
NNS.nowcast(
  h = 1,
  additional.regressors = NULL,
  additional.sources = NULL,
  specific.regressors = NULL,
  start.date = "2000-01-03",
  keep.data = FALSE,
  status = TRUE,
  ncores = NULL
)
}
\arguments{
\item{h}{integer; \code{(h = 1)} (default) Number of periods to forecast. \code{(h = 0)} will return just the interpolated and extrapolated values up to the current month.}

\item{additional.regressors}{character; \code{NULL} (default) add more regressors to the base model.  The format must utilize the \code{\link[quantmod]{getSymbols}} format for FRED data, else specify the source.}

\item{additional.sources}{character; \code{NULL} (default) specify the \code{source} argument per \code{\link[quantmod]{getSymbols}} for each \code{additional.regressors} specified.}

\item{specific.regressors}{integer; \code{NULL} (default) Select individual regressors from the base model per Viole (2020) listed in the References.}

\item{start.date}{character; \code{"2000-01-03"} (default) Starting date for all data series download.}

\item{keep.data}{logical; \code{FALSE} (default) Keeps downloaded variables in a new environment \code{NNSdata}.}

\item{status}{logical; \code{TRUE} (default) Prints status update message in console.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized subroutine \link{NNS.ARMA.optim}. If NULL (default), the number of cores to be used is equal to the number of cores of the machine - 1.}
}
\value{
Returns the following matrices of forecasted variables:
\itemize{
 \item{\code{"interpolated_and_extrapolated"}} Returns a \code{data.frame} of the linear interpolated and \link{NNS.ARMA} extrapolated values to replace \code{NA} values in the original \code{variables} argument.  This is required for working with variables containing different frequencies, e.g. where \code{NA} would be reported for intra-quarterly data when indexed with monthly periods.
 \item{\code{"relevant_variables"}} Returns the relevant variables from the dimension reduction step.

 \item{\code{"univariate"}} Returns the univariate \link{NNS.ARMA} forecasts.

 \item{\code{"multivariate"}} Returns the multi-variate \link{NNS.reg} forecasts.

 \item{\code{"ensemble"}} Returns the ensemble of both \code{"univariate"} and \code{"multivariate"} forecasts.
 }
}
\description{
Wrapper function for NNS nowcasting method using the nonparametric vector autoregression \link{NNS.VAR}, and Federal Reserve Nowcasting variables.
}
\examples{

 \dontrun{
 ## Interpolates / Extrapolates all variables to current month
 NNS.nowcast(h = 0)
 
 ## Additional regressors and sources specified
 NNS.nowcast(h = 0, additional.regressors = c("SPY", "USO"), 
             additional.sources = c("yahoo", "yahoo"))
             
              
 ### PREDICTION INTERVALS 
 ## Store NNS.nowcast output
 nns_estimates <- NNS.nowcast(h = 12)           
 
 # Create bootstrap replicates using NNS.meboot (GDP Variable)
 gdp_replicates <- NNS.meboot(nns_estimates$ensemble$GDPC1, 
                              rho = seq(0,1,.25), 
                              reps = 100)["replicates",]
                              
 replicates <- do.call(cbind, gdp_replicates)
 
 # Apply UPM.VaR and LPM.VaR for desired prediction interval...95 percent illustrated
 # Tail percentage used in first argument per {LPM.VaR} and {UPM.VaR} functions
 lower_GDP_CIs <- apply(replicates, 1, function(z) LPM.VaR(0.025, 0, z))
 upper_GDP_CIs <- apply(replicates, 1, function(z) UPM.VaR(0.025, 0, z))
 
 # View results
 cbind(nns_estimates$ensemble$GDPC1, lower_GDP_CIs, upper_GDP_CIs)
 }

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Viole, F. (2019) "Multi-variate Time-Series Forecasting: Nonparametric Vector Autoregression Using NNS"
\url{https://www.ssrn.com/abstract=3489550}

Viole, F. (2020) "NOWCASTING with NNS"
\url{https://www.ssrn.com/abstract=3589816}
}
\author{
Fred Viole, OVVO Financial Systems
}
