% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Correlation.R
\name{VN.cor}
\alias{VN.cor}
\title{VN Correlation}
\usage{
VN.cor(x, y, order = 2, degree = ifelse(length(x) < 100, 0, 1))
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{order}{Controls the level of quadrant partitioning.  Defualts to \code{order=2}.  Errors can generally be rectified by setting \code{order=1}.}

\item{degree}{Defaults to 0 for smaller number of observations.}
}
\value{
Returns nonlinear correlation coefficient between two variables, or correlation matrix for matrix input.
}
\description{
Returns the nonlinear correlation coefficient based on partial moment quadrants measured by frequency or area.  Degree = 0 is frequency, degree = 1 is area.
}
\examples{
set.seed(123)
## Pairwise Correlation
x<-rnorm(100); y<-rnorm(100)
VN.cor(x,y)

## Correlation Matrix
x<-rnorm(100); y<-rnorm(100); z<-rnorm(100)
B<-cbind(x,y,z)
VN.cor(B)

}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{correlation}

