% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Feature_probability.R
\name{Feature.probability}
\alias{Feature.probability}
\title{Feature Probability}
\usage{
Feature.probability(x, y, threshold = 0)
}
\arguments{
\item{x}{Complete cleaned dataset in matrix form.}

\item{y}{Column of data to be classified.}

\item{threshold}{Sets the correlation threshold for independent variables.  Defaults to 0.}
}
\value{
Returns two variables, mean squared error "\code{MSE}" and predicted values "\code{Predictions}" as well as Prediction Accuracy measured by percentage of exact classifications.
}
\description{
Classifies data based on feature probabilities
}
\examples{
## Using 'iris' dataset where predictive attributes are columns 1:4, and the class is column 5.
\dontrun{Feature.probability(iris,5)}

## To call mean squared error
\dontrun{Feature.probability(iris,5)$MSE}

## To call predicted values
\dontrun{Feature.probability(iris,5)$Predictions}
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Annotated code is available at
\url{https://github.com/OVVO-Financial/NNS/blob/Prelim/Feature_Probability}
}
\keyword{classifier}

