\name{trans.armdataP}
\alias{trans.armdataP}
\title{Transforming arm-specific incidence proportion or survival probability data to arm-level data}
\usage{
trans.armdataP(study,treat,y,SE,data)
}
\arguments{
\item{study}{Study ID}
\item{treat}{Treatment variable of individual arms. It can be formed as both of numbered treatment (=1,2,...) and characters (e.g., "Placebo", "ARB", "Beta blocker").}
\item{y}{Arm-specific incidence proportion or survival probability estimates.}
\item{SE}{Standard error estimate of \code{y}.}
\item{data}{A data frame that involves the summary statistics data.}
}
\value{
Estimated arm-level event counts and sample sizes are generated. Note the estimated data may not accord to the original data. However, they are solely working pseudo-data, designed so that the contrast-based statistics generated by the \code{setup} function accord to the original data. The \code{NMA} package tools rely solely on summary statistics for the synthesis analyses, so this is not problematic.
\itemize{
\item \code{study}: The ID variable that specifies studies.
\item \code{trt}: A variable that specifies treatment categories.
\item \code{d}: The estimated number of events (possibly pseudo-data; for dichotomous and survival outcomes).
\item \code{n}: The sample sizes.
}
}
\description{
The multivariate meta-analysis and meta-regression models used in \code{NMA} package require contrast-based summary statistics created by \code{setup} function. 
The \code{setup} function requires arm-level data for individual studies. 
Some studies may only report arm-specific incidence proportion or survival probability data. 
The \code{trans.armdataP} function creates arm-level data that can be used for the \code{setup} function.  
Note the estimated data may not accord to the original data. 
However, they are solely working pseudo-data, designed so that the contrast-based statistics generated by the \code{setup} function accord to the original data. 
The \code{NMA} package tools rely solely on summary statistics for the synthesis analyses, so this is not problematic. 
If there are relevant covariate data that can used for meta-regression analyses, please edit the output object before entering to the \code{setup} function; the output object can be exported to a CSV or Microsoft Excel file. 
Also, when some studies report only arm-level data, users can combine the data object of arm-based data with the output object of \code{trans.armdataP} function.
}
\examples{
data(exdataP)
trans.armdataP(study=study,treat=trt,y=y,SE=se,data=exdataP)
}
