% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependencies.R
\name{NFCP.Domains}
\alias{NFCP.Domains}
\title{N-Factor MLE Search Boundaries}
\usage{
NFCP.Domains(
  parameters,
  kappa = NULL,
  lambda = NULL,
  sigma = NULL,
  mu = NULL,
  mu_star = NULL,
  rho = NULL,
  contract = NULL,
  X.0 = NULL,
  E = NULL
)
}
\arguments{
\item{parameters}{a vector of parameter names of an N-factor model. Function \code{NFCP.Parameters} is recommended.}

\item{kappa}{A vector of length two specifying the lower and upper bounds for the 'kappa' parameter}

\item{lambda}{A vector of length two specifying the lower and upper bounds for the 'lambda' parameter}

\item{sigma}{A vector of length two specifying the lower and upper bounds for the 'sigma' parameter}

\item{mu}{A vector of length two specifying the lower and upper bounds for the 'mu' parameter}

\item{mu_star}{A vector of length two specifying the lower and upper bounds for the 'mu_star' parameter}

\item{rho}{A vector of length two specifying the lower and upper bounds for the 'rho' parameter}

\item{contract}{A vector of length two specifying the lower and upper bounds for the 'contract' parameter}

\item{X.0}{A vector of length two specifying the lower and upper bounds for the 'X.0' parameter}

\item{E}{A vector of length two specifying the lower and upper bounds for the 'E' parameter}
}
\value{
A matrix of defaulted domains for the given unknown parameters. The first column corresponds to the lower bound of the
allowable search space for the parameter, whilst the second column corresponds to the upper bound. These values were set to allow for the
'realistic' possible values of given parameters as well as restricting some parameters (such as variance and mean-reverting terms) from taking
negative values. The format of the returned matrix matches that required by the \code{Domains} argument of the \code{Genoud} function from the package \code{RGenoud}.
}
\description{
Generate boundaries for the domain of parameters of the N-factor model for parameter estimation.
}
\details{
The \code{NFCP.Domains} function generates lower and upper bounds for the parameter estimation procedure in the format required of the 'Domains' argument of the 'genoud' function. \code{NFCP.Domains}
allows easy setting of custom boundaries for parameter estimation, whilst also providing default domains of parameters.
}
\examples{
##Specify the Schwartz and Smith (2000) two-factor model
##with constant contract white noise:
SS.parameters <- NFCP.Parameters(N.factors = 2,
                                GBM = TRUE,
                                Initial.State = TRUE,
                                S.Constant = TRUE)

###Generate the default 'domains' argument of 'NFCP.MLE' function:
NFCP.MLE.Bounds <- NFCP.Domains(SS.parameters)
}
\references{
Mebane, W. R., and J. S. Sekhon, (2011). Genetic Optimization Using Derivatives: The rgenoud Package for R.
\emph{Journal of Statistical Software}, 42(11), 1-26. URL http://www.jstatsoft.org/v42/i11/.

Schwartz, E. S., and J. E. Smith, (2000). Short-Term Variations and Long-Term Dynamics in Commodity Prices. \emph{Manage. Sci.}, 46, 893-911.
}
