/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.Cache;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.common.Retriever;
import org.apache.mahout.cf.taste.impl.similarity.LongPairMatchPredicate;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.PreferenceInferrer;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;
import org.apache.mahout.common.LongPair;

public final class CachingUserSimilarity
implements UserSimilarity {
    private final UserSimilarity similarity;
    private final Cache<LongPair, Double> similarityCache;
    private final RefreshHelper refreshHelper;

    public CachingUserSimilarity(UserSimilarity similarity, DataModel dataModel) throws TasteException {
        this(similarity, dataModel.getNumUsers());
    }

    public CachingUserSimilarity(UserSimilarity similarity, int maxCacheSize) {
        Preconditions.checkArgument(similarity != null, "similarity is null");
        this.similarity = similarity;
        this.similarityCache = new Cache<LongPair, Double>(new SimilarityRetriever(similarity), maxCacheSize);
        this.refreshHelper = new RefreshHelper(new Callable<Void>(){

            @Override
            public Void call() {
                CachingUserSimilarity.this.similarityCache.clear();
                return null;
            }
        });
        this.refreshHelper.addDependency(similarity);
    }

    @Override
    public double userSimilarity(long userID1, long userID2) throws TasteException {
        LongPair key = userID1 < userID2 ? new LongPair(userID1, userID2) : new LongPair(userID2, userID1);
        return this.similarityCache.get(key);
    }

    @Override
    public void setPreferenceInferrer(PreferenceInferrer inferrer) {
        this.similarityCache.clear();
        this.similarity.setPreferenceInferrer(inferrer);
    }

    public void clearCacheForUser(long userID) {
        this.similarityCache.removeKeysMatching(new LongPairMatchPredicate(userID));
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    private static final class SimilarityRetriever
    implements Retriever<LongPair, Double> {
        private final UserSimilarity similarity;

        private SimilarityRetriever(UserSimilarity similarity) {
            this.similarity = similarity;
        }

        @Override
        public Double get(LongPair key) throws TasteException {
            return this.similarity.userSimilarity(key.getFirst(), key.getSecond());
        }
    }
}

