/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.slopeone;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.EntityEntityWritable;
import org.apache.mahout.cf.taste.hadoop.EntityPrefWritable;
import org.apache.mahout.cf.taste.hadoop.slopeone.ByItemIDComparator;
import org.apache.mahout.math.VarLongWritable;

public final class SlopeOnePrefsToDiffsReducer
extends Reducer<VarLongWritable, EntityPrefWritable, EntityEntityWritable, FloatWritable> {
    protected void reduce(VarLongWritable key, Iterable<EntityPrefWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        ArrayList<EntityPrefWritable> prefs = Lists.newArrayList();
        for (EntityPrefWritable writable : values) {
            prefs.add(new EntityPrefWritable(writable));
        }
        Collections.sort(prefs, ByItemIDComparator.getInstance());
        int size = prefs.size();
        for (int i = 0; i < size; ++i) {
            EntityPrefWritable first = (EntityPrefWritable)prefs.get(i);
            long itemAID = first.getID();
            float itemAValue = first.getPrefValue();
            for (int j = i + 1; j < size; ++j) {
                EntityPrefWritable second = (EntityPrefWritable)prefs.get(j);
                long itemBID = second.getID();
                float itemBValue = second.getPrefValue();
                context.write((Object)new EntityEntityWritable(itemAID, itemBID), (Object)new FloatWritable(itemBValue - itemAValue));
            }
        }
    }
}

