/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import com.google.common.primitives.Floats;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.common.TopK;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.item.PrefAndSimilarityColumnWritable;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.VarLongWritable;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregateAndRecommendReducer
extends Reducer<VarLongWritable, PrefAndSimilarityColumnWritable, VarLongWritable, RecommendedItemsWritable> {
    private static final Logger log = LoggerFactory.getLogger(AggregateAndRecommendReducer.class);
    static final String ITEMID_INDEX_PATH = "itemIDIndexPath";
    static final String NUM_RECOMMENDATIONS = "numRecommendations";
    static final int DEFAULT_NUM_RECOMMENDATIONS = 10;
    static final String ITEMS_FILE = "itemsFile";
    private boolean booleanData;
    private int recommendationsPerUser;
    private FastIDSet itemsToRecommendFor;
    private OpenIntLongHashMap indexItemIDMap;
    private static final float BOOLEAN_PREF_VALUE = 1.0f;
    private static final Comparator<RecommendedItem> BY_PREFERENCE_VALUE = new Comparator<RecommendedItem>(){

        @Override
        public int compare(RecommendedItem one, RecommendedItem two) {
            return Floats.compare(one.getValue(), two.getValue());
        }
    };
    private static final DoubleFunction ABSOLUTE_VALUES = new DoubleFunction(){

        public double apply(double value) {
            return value < 0.0 ? value * -1.0 : value;
        }
    };

    protected void setup(Reducer.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.recommendationsPerUser = conf.getInt(NUM_RECOMMENDATIONS, 10);
        this.booleanData = conf.getBoolean("booleanData", false);
        this.indexItemIDMap = TasteHadoopUtils.readItemIDIndexMap(conf.get(ITEMID_INDEX_PATH), conf);
        String itemFilePathString = conf.get(ITEMS_FILE);
        if (itemFilePathString != null) {
            this.itemsToRecommendFor = new FastIDSet();
            for (String line : new FileLineIterable(HadoopUtil.openStream(new Path(itemFilePathString), conf))) {
                try {
                    this.itemsToRecommendFor.add(Long.parseLong(line));
                }
                catch (NumberFormatException nfe) {
                    log.warn("itemsFile line ignored: {}", (Object)line);
                }
            }
        }
    }

    protected void reduce(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        if (this.booleanData) {
            this.reduceBooleanData(userID, values, context);
        } else {
            this.reduceNonBooleanData(userID, values, context);
        }
    }

    private void reduceBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector predictionVector = null;
        for (PrefAndSimilarityColumnWritable prefAndSimilarityColumn : values) {
            predictionVector = predictionVector == null ? prefAndSimilarityColumn.getSimilarityColumn() : predictionVector.plus(prefAndSimilarityColumn.getSimilarityColumn());
        }
        this.writeRecommendedItems(userID, predictionVector, context);
    }

    private void reduceNonBooleanData(VarLongWritable userID, Iterable<PrefAndSimilarityColumnWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        Vector numerators = null;
        Vector denominators = null;
        RandomAccessSparseVector numberOfSimilarItemsUsed = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        for (PrefAndSimilarityColumnWritable prefAndSimilarityColumn : values) {
            Vector simColumn = prefAndSimilarityColumn.getSimilarityColumn();
            float prefValue = prefAndSimilarityColumn.getPrefValue();
            Iterator usedItemsIterator = simColumn.iterateNonZero();
            while (usedItemsIterator.hasNext()) {
                int itemIDIndex = ((Vector.Element)usedItemsIterator.next()).index();
                numberOfSimilarItemsUsed.setQuick(itemIDIndex, numberOfSimilarItemsUsed.getQuick(itemIDIndex) + 1.0);
            }
            numerators = numerators == null ? (prefValue == 1.0f ? simColumn.clone() : simColumn.times((double)prefValue)) : numerators.plus(prefValue == 1.0f ? simColumn : simColumn.times((double)prefValue));
            simColumn.assign(ABSOLUTE_VALUES);
            denominators = denominators == null ? simColumn : denominators.plus(simColumn);
        }
        if (numerators == null) {
            return;
        }
        RandomAccessSparseVector recommendationVector = new RandomAccessSparseVector(Integer.MAX_VALUE, 100);
        Iterator iterator = numerators.iterateNonZero();
        while (iterator.hasNext()) {
            Vector.Element element = (Vector.Element)iterator.next();
            int itemIDIndex = element.index();
            if (!(numberOfSimilarItemsUsed.getQuick(itemIDIndex) > 1.0)) continue;
            double prediction = element.get() / denominators.getQuick(itemIDIndex);
            recommendationVector.setQuick(itemIDIndex, prediction);
        }
        this.writeRecommendedItems(userID, (Vector)recommendationVector, context);
    }

    private void writeRecommendedItems(VarLongWritable userID, Vector recommendationVector, Reducer.Context context) throws IOException, InterruptedException {
        TopK<RecommendedItem> topKItems = new TopK<RecommendedItem>(this.recommendationsPerUser, BY_PREFERENCE_VALUE);
        Iterator recommendationVectorIterator = recommendationVector.iterateNonZero();
        while (recommendationVectorIterator.hasNext()) {
            float value;
            Vector.Element element = (Vector.Element)recommendationVectorIterator.next();
            int index = element.index();
            long itemID = this.indexItemIDMap != null && !this.indexItemIDMap.isEmpty() ? this.indexItemIDMap.get(index) : (long)index;
            if (this.itemsToRecommendFor != null && !this.itemsToRecommendFor.contains(itemID) || Float.isNaN(value = (float)element.get())) continue;
            topKItems.offer((Object)new GenericRecommendedItem(itemID, value));
        }
        if (!topKItems.isEmpty()) {
            context.write((Object)userID, (Object)new RecommendedItemsWritable(topKItems.retrieve()));
        }
    }
}

