/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.TasteException;

public final class SimilarityToItemServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long toItemID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        ArrayList<Long> itemIDsList = Lists.newArrayList();
        try {
            toItemID = Long.parseLong(pathComponents.next());
            while (pathComponents.hasNext()) {
                itemIDsList.add(Long.parseLong(pathComponents.next()));
            }
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (itemIDsList.isEmpty()) {
            response.sendError(400, "No items");
            return;
        }
        long[] itemIDs = new long[itemIDsList.size()];
        for (int i = 0; i < itemIDs.length; ++i) {
            itemIDs[i] = (Long)itemIDsList.get(i);
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            float[] similarities = recommender.similarityToItem(toItemID, itemIDs);
            PrintWriter out = response.getWriter();
            for (float similarity : similarities) {
                ((Writer)out).write(Float.toString(similarity));
                ((Writer)out).write(10);
            }
        }
        catch (NoSuchItemException nsie) {
            response.sendError(404, nsie.toString());
        }
        catch (NotReadyException nre) {
            response.sendError(503, nre.toString());
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
    }
}

