/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.parallel.ExecutorUtils;

public final class DoSFilter
implements Filter {
    public static final String MAX_ACCESS_PER_HOST_PER_MIN_KEY = "maxAccessPerHostPerMin";
    private static final int DEFAULT_MAX_ACCESS_PER_HOST_PER_MIN = 1000;
    private final ConcurrentMap<String, AtomicInteger> numRecentAccesses = Maps.newConcurrentMap();
    private final Set<String> bannedIPAddresses = Sets.newSetFromMap(Maps.newConcurrentMap());
    private int maxAccessPerHostPerMin;
    private ScheduledExecutorService executor;

    @Override
    public void init(FilterConfig filterConfig) {
        String maxAccessPerHostPerMinString = filterConfig.getInitParameter(MAX_ACCESS_PER_HOST_PER_MIN_KEY);
        this.maxAccessPerHostPerMin = maxAccessPerHostPerMinString == null ? 1000 : Integer.parseInt(maxAccessPerHostPerMinString);
        Preconditions.checkArgument(this.maxAccessPerHostPerMin > 0, "Bad max accesses per host per min: {}", this.maxAccessPerHostPerMin);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.numRecentAccesses.clear();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.bannedIPAddresses.clear();
            }
        }, 1L, 1L, TimeUnit.HOURS);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isBanned(request)) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.sendError(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isBanned(ServletRequest request) {
        String remoteIPAddressString = request.getRemoteAddr();
        if (this.bannedIPAddresses.contains(remoteIPAddressString)) {
            return true;
        }
        AtomicInteger count = this.numRecentAccesses.putIfAbsent(remoteIPAddressString, new AtomicInteger(0));
        if (count.incrementAndGet() > this.maxAccessPerHostPerMin) {
            this.bannedIPAddresses.add(remoteIPAddressString);
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        ExecutorUtils.shutdownNowAndAwait(this.executor);
        this.numRecentAccesses.clear();
        this.bannedIPAddresses.clear();
    }
}

