/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import java.io.File;
import java.io.IOException;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.math.MatrixUtils;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.GenerationSerializer;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class MergeModels {
    private MergeModels() {
    }

    public static void main(String[] args) throws Exception {
        File model1File = new File(args[0]);
        File model2File = new File(args[1]);
        File mergedModelFile = new File(args[2]);
        MergeModels.merge(model1File, model2File, mergedModelFile);
    }

    public static void merge(File model1File, File model2File, File mergedModelFile) throws IOException {
        Generation model1 = GenerationSerializer.readGeneration(model1File);
        Generation model2 = GenerationSerializer.readGeneration(model2File);
        FastByIDMap<float[]> x1 = model1.getX();
        FastByIDMap<float[]> y1 = model1.getY();
        FastByIDMap<float[]> x2 = model2.getX();
        FastByIDMap<float[]> y2 = model2.getY();
        RealMatrix translation = MergeModels.multiply(y1, x2);
        FastByIDMap<float[]> xMerged = MatrixUtils.multiply(translation.transpose(), x1);
        FastIDSet emptySet = new FastIDSet();
        FastByIDMap<FastIDSet> knownItems = new FastByIDMap<FastIDSet>();
        LongPrimitiveIterator it = xMerged.keySetIterator();
        while (it.hasNext()) {
            knownItems.put(it.nextLong(), emptySet);
        }
        FastIDSet x1ItemTagIDs = model1.getItemTagIDs();
        FastIDSet y2UserTagIDs = model2.getUserTagIDs();
        Generation merged = new Generation(knownItems, xMerged, y2, x1ItemTagIDs, y2UserTagIDs);
        GenerationSerializer.writeGeneration(merged, mergedModelFile);
    }

    private static RealMatrix multiply(FastByIDMap<float[]> left, FastByIDMap<float[]> right) {
        int numRows = left.entrySet().iterator().next().getValue().length;
        int numCols = right.entrySet().iterator().next().getValue().length;
        double[][] translationData = new double[numRows][numCols];
        for (FastByIDMap.MapEntry<float[]> entry1 : left.entrySet()) {
            float[] leftCol = entry1.getValue();
            float[] rightRow = right.get(entry1.getKey());
            if (rightRow == null) continue;
            for (int row = 0; row < numRows; ++row) {
                float leftColAtRow = leftCol[row];
                double[] translationDataAtRow = translationData[row];
                for (int col = 0; col < numCols; ++col) {
                    int n = col;
                    translationDataAtRow[n] = translationDataAtRow[n] + (double)(leftColAtRow * rightRow[col]);
                }
            }
        }
        return new Array2DRowRealMatrix(translationData);
    }
}

