/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.transforms;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.transforms.Counters;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.transforms.PreferenceTransform;

public final class InverseUserFrequency
implements PreferenceTransform {
    private final DataModel dataModel;
    private final RefreshHelper refreshHelper;
    private final double logBase;
    private FastByIDMap<Double> iufFactors;

    public InverseUserFrequency(DataModel dataModel, double logBase) throws TasteException {
        Preconditions.checkArgument(logBase > 1.0, "logBase should be > 1.0");
        this.dataModel = Preconditions.checkNotNull(dataModel);
        this.logBase = logBase;
        this.iufFactors = new FastByIDMap();
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                InverseUserFrequency.this.recompute();
                return null;
            }
        });
        this.refreshHelper.addDependency(this.dataModel);
        this.recompute();
    }

    public double getLogBase() {
        return this.logBase;
    }

    @Override
    public float getTransformedValue(Preference pref) {
        Double factor = this.iufFactors.get(pref.getItemID());
        if (factor != null) {
            return (float)((double)pref.getValue() * factor);
        }
        return pref.getValue();
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    private void recompute() throws TasteException {
        Counters itemPreferenceCounts = new Counters();
        int numUsers = 0;
        LongPrimitiveIterator it = this.dataModel.getUserIDs();
        while (it.hasNext()) {
            PreferenceArray prefs = this.dataModel.getPreferencesFromUser(it.nextLong());
            int size = prefs.length();
            for (int i = 0; i < size; ++i) {
                itemPreferenceCounts.increment(prefs.getItemID(i));
            }
            ++numUsers;
        }
        FastByIDMap<Double> newIufFactors = new FastByIDMap<Double>(itemPreferenceCounts.size());
        double logFactor = Math.log(this.logBase);
        for (Map.Entry<Long, int[]> entry : itemPreferenceCounts.getEntrySet()) {
            newIufFactors.put(entry.getKey(), Math.log((double)numUsers / (double)entry.getValue()[0]) / logFactor);
        }
        this.iufFactors = newIufFactors;
    }

    public String toString() {
        return "InverseUserFrequency[logBase:" + this.logBase + ']';
    }
}

