/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity.file;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.common.iterator.FileLineIterator;

final class FileItemItemSimilarityIterator
extends ForwardingIterator<GenericItemSimilarity.ItemItemSimilarity> {
    private static final Pattern SEPARATOR = Pattern.compile("[,\t]");
    private final Iterator<GenericItemSimilarity.ItemItemSimilarity> delegate;

    FileItemItemSimilarityIterator(File similaritiesFile) throws IOException {
        this.delegate = Iterators.transform(new FileLineIterator(similaritiesFile), new Function<String, GenericItemSimilarity.ItemItemSimilarity>(){

            @Override
            public GenericItemSimilarity.ItemItemSimilarity apply(String from) {
                String[] tokens = SEPARATOR.split(from);
                return new GenericItemSimilarity.ItemItemSimilarity(Long.parseLong(tokens[0]), Long.parseLong(tokens[1]), Double.parseDouble(tokens[2]));
            }
        });
    }

    @Override
    protected Iterator<GenericItemSimilarity.ItemItemSimilarity> delegate() {
        return this.delegate;
    }
}

