/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.online.AbstractRescorerProvider;
import net.myrrix.online.MultiLongPairRescorer;
import net.myrrix.online.MultiRescorer;
import net.myrrix.online.RescorerProvider;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public final class MultiRescorerProvider
extends AbstractRescorerProvider {
    private final RescorerProvider[] providers;

    public MultiRescorerProvider(RescorerProvider ... providers) {
        Preconditions.checkNotNull(providers);
        Preconditions.checkArgument(providers.length > 0, "providers is empty");
        this.providers = providers;
    }

    public MultiRescorerProvider(List<RescorerProvider> providers) {
        Preconditions.checkNotNull(providers);
        Preconditions.checkArgument(!providers.isEmpty());
        this.providers = providers.toArray(new RescorerProvider[providers.size()]);
    }

    @Override
    public IDRescorer getRecommendRescorer(long[] userIDs, MyrrixRecommender recommender, String ... args) {
        ArrayList<IDRescorer> rescorers = Lists.newArrayListWithCapacity(this.providers.length);
        for (RescorerProvider provider : this.providers) {
            IDRescorer rescorer = provider.getRecommendRescorer(userIDs, recommender, args);
            if (rescorer == null) continue;
            rescorers.add(rescorer);
        }
        return MultiRescorerProvider.buildRescorer(rescorers);
    }

    @Override
    public IDRescorer getRecommendToAnonymousRescorer(long[] itemIDs, MyrrixRecommender recommender, String ... args) {
        ArrayList<IDRescorer> rescorers = Lists.newArrayListWithCapacity(this.providers.length);
        for (RescorerProvider provider : this.providers) {
            IDRescorer rescorer = provider.getRecommendToAnonymousRescorer(itemIDs, recommender, args);
            if (rescorer == null) continue;
            rescorers.add(rescorer);
        }
        return MultiRescorerProvider.buildRescorer(rescorers);
    }

    @Override
    public IDRescorer getMostPopularItemsRescorer(MyrrixRecommender recommender, String ... args) {
        ArrayList<IDRescorer> rescorers = Lists.newArrayListWithCapacity(this.providers.length);
        for (RescorerProvider provider : this.providers) {
            IDRescorer rescorer = provider.getMostPopularItemsRescorer(recommender, args);
            if (rescorer == null) continue;
            rescorers.add(rescorer);
        }
        return MultiRescorerProvider.buildRescorer(rescorers);
    }

    private static IDRescorer buildRescorer(List<IDRescorer> rescorers) {
        int numRescorers = rescorers.size();
        if (numRescorers == 0) {
            return null;
        }
        if (numRescorers == 1) {
            return rescorers.get(0);
        }
        return new MultiRescorer(rescorers);
    }

    @Override
    public Rescorer<LongPair> getMostSimilarItemsRescorer(MyrrixRecommender recommender, String ... args) {
        ArrayList<Rescorer<LongPair>> rescorers = Lists.newArrayListWithCapacity(this.providers.length);
        for (RescorerProvider provider : this.providers) {
            Rescorer<LongPair> rescorer = provider.getMostSimilarItemsRescorer(recommender, args);
            if (rescorer == null) continue;
            rescorers.add(rescorer);
        }
        int numRescorers = rescorers.size();
        if (numRescorers == 0) {
            return null;
        }
        if (numRescorers == 1) {
            return (Rescorer)rescorers.get(0);
        }
        return new MultiLongPairRescorer(rescorers);
    }
}

