/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.neighborhood;

import com.google.common.base.Preconditions;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.neighborhood.AbstractUserNeighborhood;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.UserSimilarity;

public final class NearestNUserNeighborhood
extends AbstractUserNeighborhood {
    private final int n;
    private final double minSimilarity;

    public NearestNUserNeighborhood(int n, UserSimilarity userSimilarity, DataModel dataModel) throws TasteException {
        this(n, Double.NEGATIVE_INFINITY, userSimilarity, dataModel, 1.0);
    }

    public NearestNUserNeighborhood(int n, double minSimilarity, UserSimilarity userSimilarity, DataModel dataModel) throws TasteException {
        this(n, minSimilarity, userSimilarity, dataModel, 1.0);
    }

    public NearestNUserNeighborhood(int n, double minSimilarity, UserSimilarity userSimilarity, DataModel dataModel, double samplingRate) throws TasteException {
        super(userSimilarity, dataModel, samplingRate);
        Preconditions.checkArgument(n >= 1, "n must be at least 1");
        int numUsers = dataModel.getNumUsers();
        this.n = n > numUsers ? numUsers : n;
        this.minSimilarity = minSimilarity;
    }

    @Override
    public long[] getUserNeighborhood(long userID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        UserSimilarity userSimilarityImpl = this.getUserSimilarity();
        Estimator estimator = new Estimator(userSimilarityImpl, userID, this.minSimilarity);
        LongPrimitiveIterator userIDs = SamplingLongPrimitiveIterator.maybeWrapIterator(dataModel.getUserIDs(), this.getSamplingRate());
        return TopItems.getTopUsers(this.n, userIDs, null, estimator);
    }

    public String toString() {
        return "NearestNUserNeighborhood";
    }

    private static final class Estimator
    implements TopItems.Estimator<Long> {
        private final UserSimilarity userSimilarityImpl;
        private final long theUserID;
        private final double minSim;

        private Estimator(UserSimilarity userSimilarityImpl, long theUserID, double minSim) {
            this.userSimilarityImpl = userSimilarityImpl;
            this.theUserID = theUserID;
            this.minSim = minSim;
        }

        @Override
        public double estimate(Long userID) throws TasteException {
            if (userID == this.theUserID) {
                return Double.NaN;
            }
            double sim = this.userSimilarityImpl.userSimilarity(this.theUserID, userID);
            return sim >= this.minSim ? sim : Double.NaN;
        }
    }
}

