% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LC.R
\name{lileecarter.estimate}
\alias{lileecarter.estimate}
\title{Coherent Lee-Carter Estimation}
\usage{
lileecarter.estimate(mxM, mxF, nx = 5, ...)
}
\arguments{
\item{mxM}{A matrix of male age-specific mortality rates where rows correspond to age groups
and columns correspond to time periods. For 5-year age groups, the first and second rows corresponds to 
0-1 and 1-5 age groups, respectively. Rownames define the starting ages of the respective groups.}

\item{mxF}{A matrix of female mortality rates of the same shape as \code{mxM}.}

\item{nx}{Size of age groups. Should be either 5 or 1.}

\item{...}{Additional arguments passed to \code{\link{leecarter.estimate}}.}
}
\value{
List containing elements \code{bx} (coherent \eqn{b_x} parameter), 
    \code{ultimate.bx} (ultimate \eqn{b^u_x} parameter), \code{ages} (age groups), \code{nx} (age group interval), and
  lists \code{female} and \code{male}, each with the Lee-Carter parameters.
}
\description{
Estimate coherent Lee-Carter parameters (Li and Lee 2005).
}
\details{
The coherent Lee-Carter parameters for male and female mortality rates 
    share the same \eqn{b_x} which is the average of the age-specific 
    \eqn{b_x} parameters. 
    
    The function in addition computes the ultimate \eqn{b^u_x} as defined in 
    Li et al. (2013) based on the coherent \eqn{b_x}.
}
\examples{
data(mxM, mxF, package = "wpp2017")
country <- "Germany"
mxm <- subset(mxM, name == country)[,4:16]
mxf <- subset(mxF, name == country)[,4:16]
rownames(mxm) <- rownames(mxf) <- c(0,1, seq(5, 100, by=5))
lc <- lileecarter.estimate(mxm, mxf)
plot(lc$bx, type="l")
lines(lc$ultimate.bx, lty=2)

}
\references{
Li, N. and Lee, R. D. (2005). Coherent mortality forecasts for a group of populations: 
An extension of the Lee-Carter method. Demography, 42, 575-594.

Li, N., Lee, R. D. and Gerland, P. (2013). Extending the Lee-Carter method to model the rotation 
of age patterns of mortality decline for long-term projections. Demography, 50, 2037-2051.
}
