% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deformGrid3d.r
\name{deformGrid3d}
\alias{deformGrid3d}
\title{visualise differences between two superimposed sets of 3D landmarks}
\usage{
deformGrid3d(matrix, tarmatrix, ngrid = 0, align = FALSE, lwd = 1,
  showaxis = c(1, 2), show = c(1, 2), lines = TRUE, lcol = 1,
  add = FALSE, col1 = 2, col2 = 3, type = c("s", "p"),
  size = NULL, pcaxis = FALSE, ask = TRUE, margin = 0.2,
  createMesh = FALSE, slice1 = NULL, slice2 = NULL, slice3 = NULL,
  gridcol = 1, gridwidth = 1, ...)
}
\arguments{
\item{matrix}{reference matrix containing 3D landmark coordinates or mesh of class "mesh3d"}

\item{tarmatrix}{target matrix containing 3D landmark coordinates or mesh of class "mesh3d"}

\item{ngrid}{number of grid lines to be plotted; ngrid=0 suppresses grid
creation.}

\item{align}{logical: if TRUE, \code{tarmatrix} will be aligned rigidly to \code{matrix}}

\item{lwd}{width of lines connecting landmarks.}

\item{showaxis}{integer (vector): which dimensions of the grid to be
plotted. Options are combinations of 1,2 and 3.}

\item{show}{integer (vector): if c(1:2) both configs will be plotted, show = 1 only plots the reference and show = 2 the target}

\item{lines}{logical: if TRUE, lines between landmarks will be plotted.}

\item{lcol}{color of lines}

\item{add}{logical: add to existing rgl window.}

\item{col1}{color of "matrix"}

\item{col2}{color of "tarmat"}

\item{type}{"s" renders landmarks as spheres; "p" as points - much faster
for very large pointclouds.}

\item{size}{control size/radius of points/spheres}

\item{pcaxis}{logical: align grid by shape's principal axes.}

\item{ask}{logical: if TRUE for > 1000 coordinates the user will be asked to prefer points over spheres.}

\item{margin}{margin around the bounding box to draw the grid}

\item{createMesh}{logical: if TRUE, a triangular mesh of spheres and displacement vectors (can take some time depending on number of reference points and grid density).}

\item{slice1}{integer or vector of integers: select slice(s) for the dimensions}

\item{slice2}{integer or vector of integers: select slice(s) for the dimensions}

\item{slice3}{integer or vector of integers: select slice(s) for the dimensions}

\item{gridcol}{define color of grid}

\item{gridwidth}{integer: define linewidth of grid}

\item{...}{additional parameters passed to \code{\link{rotonto}} in case \code{align=TRUE}}
}
\value{
if \code{createMesh=TRUE}, a mesh containing spheres of reference and target as well as the displacement vectors is returned.
}
\description{
visualise differences between two superimposed sets of 3D landmarks by
deforming a cubic grid based on a thin-plate spline interpolation
}
\examples{
\dontrun{
data(nose)
deformGrid3d(shortnose.lm,longnose.lm,ngrid=10)

## select some slices
deformGrid3d(shortnose.lm,longnose.lm,showaxis=1:3,ngrid=10,slice1=2,slice2=5,slice3=7)
}
}
\seealso{
\code{\link{tps3d}}
}
\author{
Stefan Schlager
}
