% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data2platonic.r
\name{data2platonic}
\alias{data2platonic}
\title{creates 3D shapes from data to be saved as triangular meshes}
\usage{
data2platonic(
  datamatrix,
  shape = Rvcg::vcgSphere(),
  col = "red",
  scale = FALSE,
  scalefactor = 1
)
}
\arguments{
\item{datamatrix}{k x 3 data matrix}

\item{shape}{a 3D shape}

\item{col}{color value}

\item{scale}{logical: whether to scale the data to unit sd.}

\item{scalefactor}{scale the resulting shapes.}
}
\value{
returns all shapes merged into a single mesh
}
\description{
creates 3D shapes from 3-dimensional data that can be saved as triangular meshes
}
\examples{

mymesh <- data2platonic(iris[iris$Species=="setosa",1:3],scalefactor=0.1)
mymesh <- mergeMeshes(mymesh,data2platonic(iris[iris$Species=="versicolor",1:3],
                      shape=Rvcg::vcgIcosahedron(),scalefactor=0.1,col="green"))
mymesh <- mergeMeshes(mymesh,data2platonic(iris[iris$Species=="virginica",1:3],
                      shape=Rvcg::vcgTetrahedron(),scalefactor=0.1,col="blue"))
\dontrun{
rgl::shade3d(mymesh)
## save to disk
Rvcg::vcgPlyWrite(mymesh,filename="3D_Data.ply")
}
}
