% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{subsetData}
\alias{subsetData}
\alias{TrainingandTestData}
\alias{newData}
\alias{splitdata}
\title{Dataset subsetting}
\usage{
TrainingandTestData(data, percentage_test, discreteVariables = NULL)

newData(data, nameX, nameY)

splitdata(data, nameVariable, min, max)
}
\arguments{
\item{data}{A dataset of class \code{data.frame}.}

\item{percentage_test}{The proportion of data that goes to the test set (between 0 and 1).}

\item{discreteVariables}{A \code{character} vector with the name of the discrete variables.}

\item{nameX}{A \code{character} vector with the name of the child variable in the conditional method.}

\item{nameY}{A \code{character} vector with the name of the parent variables in the conditional method.}

\item{nameVariable}{A \code{character} vector with the name of the variable to be filtered.}

\item{min, max}{Boundary values to filter out.}
}
\value{
\code{TrainingandTestData()} returns a list of 2 elements containing the train and test datasets. 
\code{newData()} and \code{splitdata()} return a subset of variables or observations, respectively.
}
\description{
Collection of functions for subsetting a \code{"data.frame"} by rows or columns, and
to create training and test partitions.
}
\examples{
\donttest{
## Dataset
X <- rnorm(1000)
Y <- rchisq(1000, df = 8)
Z <- rep(letters[1:10], times = 1000/10)
data <- data.frame(X = X, Y = Y, Z = Z)
data <- discreteVariables_as.character(dataset = data, discreteVariables ="Z")

## Training and Test Datasets
TT <- TrainingandTestData(data, percentage_test = 0.2)
TT$Training
TT$Test

## Subset Dataset
newData(data, nameX = "X", nameY = "Z")
splitdata(data, nameVariable = "X", min = 2, max= 3)
}
}
