% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorKnowledge.R
\name{generateNormalPriorData}
\alias{generateNormalPriorData}
\title{Prior data generation}
\usage{
generateNormalPriorData(graph, data, size, means, deviations = NULL)
}
\arguments{
\item{graph}{A network of the class \code{"bn"}, \code{"graphNEL"} or \code{"network"}.}

\item{data}{An object of class \code{"data.frame"} containing the continuous variables in the dataset.}

\item{size}{A positive integer indicating the number of records to generate for each variable in the dataset.}

\item{means}{A \code{"numeric"} vector with the average of the variables whose prior information is available. 
The names in the vector must be the same as the names of the variables in the data.frame.}

\item{deviations}{A \code{"numeric"} vector with the standard deviations of the variables whose prior information is available. 
The names of the vector must be the same as the names of the variables in the data.frame. 
If not specified, the standard deviation of each variable is computed from 'data'.}
}
\value{
A normal prior data set of class \code{"data.frame"}.
}
\description{
Generate a prior dataset taking in to account the relationships
between the varibles in a given network.
}
\examples{

## Data
data(ecoli)
data <- ecoli[,-c(1,9)] ## remove sequece.name and class
X <- TrainingandTestData(data, percentage_test = 0.95)
Xtraining <- X$Training
Xtest <- X$Test

## DAG
dag <- LearningHC(data)
plot(dag)

## Means and desviations
colnames(data)

m <- sapply(data, function(x){ifelse(is.numeric(x), mean(x),NA)})
d <- sapply(data, function(x){ifelse(is.numeric(x), sd(x),NA)})


## Prior Dataset
n <- 5600
priorData <- generateNormalPriorData(dag, data = Xtraining, size = n, means = m)
summary(priorData)
ncol(priorData)
nrow(priorData)
class(priorData)

}
\seealso{
\link{rnormMultiv}
}
