% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MoTBFClass.R
\name{summary.jointmotbf}
\alias{summary.jointmotbf}
\alias{print.summary.jointmotbf}
\title{Summary of a \code{"jointmotbf"} Object}
\usage{
\method{summary}{jointmotbf}(object, ...)

\method{print}{summary.jointmotbf}(x, ...)
}
\arguments{
\item{object}{An object of class \code{"jointmotbf"}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object of class \code{"summary.jointmotbf"}.}
}
\value{
The summary of a \code{"jointmotbf"} object. It contains a list of
elements with the most important information of the object.
}
\description{
Summarize a \code{"jointmotbf"} object by describing its main points.
}
\examples{
## 1. EXAMPLE
X <- rnorm(100)
Y <- rexp(100)
data <- data.frame(X, Y)
dim <- c(3,4)
param <- parametersJointMoTBF(data, dimensions=dim)
P <- jointMoTBF(param)
summary(P)
attributes(sP <- summary(P))
attributes(sP)
sP$Function
sP$Domain
sP$Iterations

##############################################################################
## MORE EXAMPLES #############################################################
##############################################################################
\donttest{
X <- rnorm(100)
Y <- rexp(100)
Z <- rnorm(100, mean=1)
data <- data.frame(X, Y, Z)
dim <- c(3,2,4)
param <- parametersJointMoTBF(data, dimensions=dim)
P <- jointMoTBF(param)
summary(P)
attributes(sP <- summary(P))
sP$Function
sP$Domain
sP$Iterations
}
##############################################################################
##############################################################################
}
\seealso{
\link{parametersJointMoTBF} and \link{jointMoTBF}
}
