% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/joint.R
\name{nVariables}
\alias{nVariables}
\title{Number of Variables in a Joint Function}
\usage{
nVariables(P)
}
\arguments{
\item{P}{An \code{"motbf"} object or a \code{"jointmotbf"} object.}
}
\value{
A \code{"character"} vector with the names of variables of the function.
}
\description{
Compute the number of variables which are in a 'jointmotbf' object.
}
\examples{
# 1. EXAMPLE
## Dataset
require(mnormt) ## Load the package to generate a multinormal dataset
## Dataset
Mean <- 0; nVar <- 2; ro <- 0
varcov <- matrix(c(rep(c(1, rep(ro, nVar)), nVar-1),1), nrow=nVar)
means <- rep(Mean, nVar)
X <- rmnorm(100,means,varcov)
data <- standardizeDataset(data.frame(X))

## Joint function
dim <-c(3,2)
param <- parametersJointMoTBF(data, dimensions = dim)
P <- jointMoTBF(param)
P

## Variables
nVariables(P)

##############################################################################
## MORE EXAMPLES #############################################################
##############################################################################
## ## Dataset
## Mean <- 0; nVar <- 3; ro <- 0
## varcov <- matrix(c(rep(c(1, rep(ro, nVar)), nVar-1),1), nrow=nVar)
## means <- rep(Mean, nVar)
## X <- rmnorm(100,means,varcov)
## data <- standardizeDataset(data.frame(X))
##
## ## Joint function
## dim <- c(2,1,3)
## param <- parametersJointMoTBF(data, dimensions = dim)
## P <- jointMoTBF(param)
##
## ## Variables
## nVariables(P)
#############################################################################
#############################################################################
}

