% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/motbf.R
\name{BICMoTBF}
\alias{BICMoTBF}
\title{Computing the BIC Score of an MoTBF Function}
\usage{
BICMoTBF(Px, X)
}
\arguments{
\item{Px}{A function of class \code{"motbf"}.}

\item{X}{A \code{"numeric"} vector with the data to evaluate.}
}
\value{
A \code{"numeric"} value containing the BIC score.
}
\description{
Computes the Bayesian information criterion value (BIC) of a
mixture of truncated basis function. The BIC score is the log likelihood
penalizes by the number of parameters of the function and the number of
records of the evaluated data.
}
\examples{
## Data
X <- rexp(10000)

## Data test
Xtest <- rexp(1000)
Xtest <- Xtest[Xtest>=min(X) && Xtest<=max(X)]

## Learning
f1 <- univMoTBF(X, POTENTIAL_TYPE = "MOP", nparam = 10); f1
f2 <- univMoTBF(X, POTENTIAL_TYPE = "MTE", maxParam = 11); f2

## BIC values
BICMoTBF(Px = f1, X = Xtest)
BICMoTBF(Px = f2, X = Xtest)
}
\seealso{
\link{univMoTBF}
}

