% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmarks.R
\name{benchmarks-functions}
\alias{benchmarks-functions}
\alias{benchmark.random}
\alias{benchmark.kmeans_lda}
\title{Benchmarks functions for clustering}
\usage{
benchmark.random(dtm, Q, ...)

benchmark.kmeans_lda(dtm, Q, K, nruns = 1, ...)
}
\arguments{
\item{dtm}{an S4 object of class \code{\linkS4class{mmpcaClust}}}

\item{Q}{The number of clusters}

\item{...}{Some argument to be consistent with the function's skeleton :
\code{K} and \code{nruns} are optional arguments for some of them.}

\item{K}{Number of topics (dimension of the latent space).}

\item{nruns}{Number of restart of the \code{\link[stats]{kmeans}}()
algorithm.}
}
\value{
A vector of size equal to the number of row of \code{dtm}, containing
  a Q-clustering
}
\description{
These are wrapper to other methods for the clustering of count
  data. They can be used to initialize the clustering. It is also possible to
  implement your own benchmark function depending on other packages.
}
\section{\code{benchmark.random}}{

Random initialisation of the clustering. Arguments K and nruns are unused
}

\section{\code{benchmarks.kmeans_lda}}{
 Cluster the matrix theta obtained by a
  topicmodels LDA with K topics
}

