% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semiregBinom.R
\name{semimrBin}
\alias{semimrBin}
\title{Semiparametric Mixture of Binomial Regression with a Degenerate Component
with Time-Varying Proportion and Time-Varying Success Probability}
\usage{
semimrBin(t, x, N, tg = NULL, tune = 1, tol = 1e-02)
}
\arguments{
\item{t}{a vector of time variable along which \eqn{w(t)} and \eqn{p(t)} vary.
See details for the explanations of those notations.}

\item{x}{a vector of observed number of successes. The length of \code{t} and \code{x} must be the same.}

\item{N}{a scalar, specifying the number of trials for the Binomial distribution.}

\item{tg}{grid points of time used in the kernel regression for the estimation of \eqn{w(t)} and \eqn{p(t)}.
Default is NULL, and 100 equally spaced grid points will automatically generated
using the minimum and maximum values of \code{t}.}

\item{tune}{a scalar related to the bandwidth selection and local estimation. Default is 1.
If greater than 0.2, the bandwidth is found based on the method in Cao and Yao (2012).
If smaller than or equal to 0.2, this value is used as the percentage of data included in local estimation.}

\item{tol}{stopping criteria for the algorithm.}
}
\value{
A list containing the following elements:
\item{pt}{estimated time-varying success probabilities for the first component.}
\item{wt}{estimated time-varying proportions for the first component.}
\item{h}{bandwidth for the kernel regression. The bandwidth calculation can be found in Section 4 of Cao and Yao (2012).}
}
\description{
`semimrBin' is used for semiparametric estimation of a mixture of binomial distributions
with one degenerate component, with time-varying proportions and time-varying success probability
(Cao and Yao, 2012).
}
\details{
The semiparametric mixture of binomial regression model is as follows:
\deqn{w(t) \times B(N,p(t))+(1-w(t))\times B(N,0),}
where \eqn{B(N,p)} is the probability mass function of a binomial distribution
with the number of trials \eqn{N} and the success probability \eqn{p}.
Here, the second component is a degenerate distribution with mass 1 on 0.
The time-varying proportion \eqn{w(t)} and success probability \eqn{p(t)} for the binomial components
are estimated by the kernel regression with some bandwidth.
}
\examples{
n = 100
tg = seq(from = 0, to = 1, length.out = 50)
t = seq(from = 0, to = 1, length.out = n)
pt = 0.5 * (1 - cos(2 * pi * t))
b = rbinom(n, 1, 0.2)
y = apply(X = matrix(pt), 1, rbinom, n = 1, size = 7)
y = ifelse(b == 1, 0, y)
ft = semimrBin(t = t, x = y, N = 7, tg = tg)
}
\references{
Cao, J. and Yao, W. (2012). Semiparametric mixture of binomial regression with a degenerate component.
Statistica Sinica, 27-46.
}
\seealso{
\code{\link{semimrBinOne}}, \code{\link{semimrBinFull}}
}
