% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_model.R
\name{run_model}
\alias{run_model}
\title{Run the JAGS model}
\usage{
run_model(run, mix, source, discr, model_filename, alpha.prior = 1, resid_err,
  process_err)
}
\arguments{
\item{run}{list of MCMC parameters (chainLength, burn, thin, chains, calcDIC).
Alternatively, a user can use a pre-defined parameter set by specifying a
valid string:
\itemize{
 \item \code{"test"}: chainLength=1000, burn=500, thin=1, chains=3
 \item \code{"very short"}: chainLength=10000, burn=5000, thin=5, chains=3
 \item \code{"short"}: chainLength=50000, burn=25000, thin=25, chains=3
 \item \code{"normal"}: chainLength=100000, burn=50000, thin=50, chains=3
 \item \code{"long"}: chainLength=300000, burn=200000, thin=100, chains=3
 \item \code{"very long"}: chainLength=1000000, burn=500000, thin=500, chains=3
 \item \code{"extreme"}: chainLength=3000000, burn=1500000, thin=500, chains=3
}}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{source}{output from \code{\link{load_source_data}}}

\item{discr}{output from \code{\link{load_discr_data}}}

\item{model_filename}{name of JAGS model file (usually should match \code{filename}
input to \code{\link{write_JAGS_model}}).}

\item{alpha.prior}{Dirichlet prior on p.global (default = 1, uninformative)}

\item{resid_err}{include residual error in the model?}

\item{process_err}{include process error in the model?}
}
\value{
jags.1, a \code{rjags} model object

\emph{Note: Tracer values are normalized before running the JAGS model.} This
allows the same priors to be used regardless of scale of the tracer data, 
without using the data to select the prior (i.e. by setting the prior mean equal
to the sample mean). Normalizing the tracer data does not affect the proportion
estimates (p_k), but does affect users seeking to plot the posterior predictive
distribution for their data. For each tracer, we calculate the pooled mean and
standard deviation of the mix and source data, then subtract the pooled mean 
and divide by the pooled standard deviation from the mix and source data. 
For details, see lines 226-269.
}
\description{
\code{run_model} calls JAGS to run the mixing model created by
\code{\link{write_JAGS_model}}. This happens when the "RUN MODEL" button is
clicked in the GUI.
}
