% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{rotl_pq}
\alias{rotl_pq}
\title{rotl wrapper for phyloseq data}
\usage{
rotl_pq(physeq, species_colnames = "Genus_species", context_name = "All life")
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{species_colnames}{(default: "Genus_species"): the name of the column
where the species binominal name is stored in \verb{@tax_table} slot.
Can also be a vector of two columns names e.g. \code{c("Genus", "Species")}}

\item{context_name}{: can bue used to select only a part of the Open Tree
of Life. See \code{?rotl::tnrs_contexts()} for available values}
}
\value{
A plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Make a phylogenetic tree using the ASV names of a physeq object and the
Open Tree of Life tree.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{rotl} package if you
use this function.
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (requireNamespace("rotl")) {
  tr <- rotl_pq(data_fungi_mini, species_colnames = "Genus_species")
  plot(tr)

  tr_Asco <- rotl_pq(data_fungi, species_colnames = "Genus_species", context_name = "Ascomycetes")
  plot(tr_Asco)
}
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
