% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{add_funguild_info}
\alias{add_funguild_info}
\title{Add information about Guild for FUNGI the FUNGuild databse}
\usage{
add_funguild_info(
  physeq,
  taxLevels = c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species"),
  db_url = "http://www.stbates.org/funguild_db_2.php"
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{taxLevels}{Name of the 7 columns in tax_table required by funguild}

\item{db_url}{a length 1 character string giving the URL to retrieve the database
from}
}
\value{
A new object of class \code{physeq} with Guild information added to
\code{tax_table} slot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Please cite Nguyen et al. 2016 (\doi{doi:10.1016/j.funeco.2015.06.006})
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{FUNGuildR} package and the associate
publication (\doi{doi:10.1016/j.funeco.2015.06.006}) if you
use this function.
}
\examples{
\dontrun{
# to avoid bug in CRAN when internet is not available
if (requireNamespace("httr")) {
  d_fung_mini <- add_funguild_info(data_fungi_mini,
    taxLevels = c(
      "Domain",
      "Phylum",
      "Class",
      "Order",
      "Family",
      "Genus",
      "Species"
    )
  )
  sort(table(d_fung_mini@tax_table[, "guild"]), decreasing = TRUE)
}
}
}
\seealso{
\code{\link[=plot_guild_pq]{plot_guild_pq()}}
}
\author{
Adrien Taudière
}
