% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{QCprep}
\alias{QCprep}
\title{QCprep}
\usage{
QCprep(mat, PARAM_metaboAge, quiet = TRUE, Nmax_zero = 1, Nmax_miss = 1)
}
\arguments{
\item{mat}{numeric data-frame NH-metabolomics matrix.}

\item{PARAM_metaboAge}{list containing all the parameters to compute the metaboAge (metabolic features list,BBMRI-nl means and SDs of the metabolic features, and coefficients)}

\item{quiet}{logical to suppress the messages in the console}

\item{Nmax_zero}{numberic value indicating the maximum number of zeros allowed per sample (Number suggested=1)}

\item{Nmax_miss}{numberic value indicating the maximum number of missing values allowed per sample (Number suggested=1)}
}
\value{
Nightingale-metabolomics data-frame after pre-processing (checked for zeros, missing values, samples>5SD from the BBMRI-mean, imputing the missing values and z-scaled)
}
\description{
Helper function to pre-process the Nightingale Health metabolomics data-set before applying the MetaboAge score by van den Akker et al.
}
\examples{
library(MiMIR)

#load the Nightignale metabolomics dataset
metabolic_measures <- synthetic_metabolic_dataset

#Pre-process the metabolic features
prepped_met<-QCprep(as.matrix(metabolic_measures[,metabolites_subsets$MET63]), PARAM_metaboAge)

}
\references{
This function is constructed to be able to follow the pre-processing steps described in:
van den Akker Erik B. et al. (2020) Metabolic Age Based on the BBMRI-NL 1H-NMR Metabolomics Repository as Biomarker of Age-related Disease. Circulation: Genomic and Precision Medicine, 13, 541–547, doi:10.1161/CIRCGEN.119.002610
}
\seealso{
apply.fit
}
