% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIMet.R
\name{SIMet}
\alias{SIMet}
\title{Sequential Increase in Metabolites for the PCA or PLS classifier}
\usage{
SIMet(TopK = 15, Survival, Mdata, Censor, Reduce = TRUE, Select = 50,
  Prognostic = NULL, Plot = FALSE, DimMethod = c("PLS", "PCA"), ...)
}
\arguments{
\item{TopK}{Top K metabolites (15 by default) to be used in the sequential analysis.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Plot}{A boolean parameter indicating if Plot should be shown. Default is FALSE}

\item{DimMethod}{Dimension reduction method which can either be PLS or PCA.}

\item{...}{Additinal arguments for plotting and only valid  if Plot=TRUE}
}
\value{
A list containing a data frame with estimated HR along with 95\% CI at each TopK value for the sequential analysis.
  \item{Result}{The hazard ratio statistics (HR, Lower confidence interval and upper confidence interval) of the lower riskgroup based for each sequential metabolite analysis}
  \item{TopKplot}{A graphical representation of the Result containing the hazard ratio statistics}
}
\description{
The Function fits cox proportional hazard model and does classification by sequentially increasing the metabolites  using either PCA or PLS based on the topK metabolites specified.
}
\details{
This function sequentially increase the number of top K metabolites to be used in the PCA or PLS methods in order to obtain the risk score. This function internally calls \code{\link[MetabolicSurv]{MSpecificCoxPh}} to rank the metabolites based on HR for each metabolite. Therefore metabolites can be ordered based on increasing order of the HR for low risk group. Thereafter, the function takes few top K (15 is the default) to be used in the sequential analysis.
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Example1 = SIMet(TopK = 10, Survival=Data$Survival,
Mdata=t(Data$Mdata), Censor=Data$Censor, Reduce = TRUE,
Select = 50,Prognostic = Data$Prognostic, Plot = TRUE, DimMethod ="PLS")

## FOR THE HR STATISTICS
Example1$Result

## FOR THE GRAPHICAL OUTPUT
Example1$TopKplot
}
}
\references{
\insertRef{ye2}{MetabolicSurv}

\insertRef{ye1}{MetabolicSurv}
}
\seealso{
\code{\link[survival]{coxph}},  \code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[MetabolicSurv]{MSpecificCoxPh}}, \code{\link[MetabolicSurv]{SurvPcaClass}}, \code{\link[MetabolicSurv]{SurvPcaClass}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
