% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_loo-methods.R
\docType{methods}
\name{mr_loo}
\alias{mr_loo}
\alias{mr_loo,MRInput-method}
\title{Leave-one-out estimates}
\usage{
mr_loo(object, alpha = 0.05)

\S4method{mr_loo}{MRInput}(object, alpha = 0.05)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{alpha}{The significance level used to calculate the confidence intervals. The default value is 0.05, corresponding to 95\% confidence intervals.}
}
\description{
The \code{mr_loo} function draws a forest plot of causal estimates from the \code{mr_ivw} function using default settings (assuming variants are uncorrelated, random-effects for 4+ variants) omitting each variant in turn. So the estimate labelled \code{snp_1} includes all variants except the labelled variant, and so on. The \code{mr_ivw} estimate including all variants ("IVW estimate") is also provided for reference.
}
\details{
As the function produces a \code{ggplot} object, graphical parameters can be changed by adding commands from the \code{ggplot2} package.
}
\examples{
mr_loo(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse),
  alpha = 0.01)

}
