\name{ADSSModExample3}
\alias{ADSSModExample3}
\title{
Simulation-based design of an adaptive trial with event count re-estimation (time-to-event endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial where the primary efficacy endpoint is a time-to-event endpoint, e.g., the time to disease progression or death.
A single regimen of an experimental treatment will be compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial may be stopped due to futility if a significant treatment effect is unlikely to be established at the final analysis (FA).
    \item Event count re-estimation rule will be applied at the second interim analysis (IA2). The target number of events of interest will be increased to improve the probability of success if conditional power is lower than expected at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 220 enrolled patients per arm will be used in the trial. 
    \item The original number of events at FA is set to 300.
    \item The annual patient dropout rate is equal to 5\% (the time to patient dropout is assumed to follow an exponential distribution).
    \item The length of the patient enrollment period is 12 months and the median enrollment time is anticipated to be 8 months, i.e., 50\% of the patients are expected to be enrolled into the trial by the 8-month milestone.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim analyses will be performed after 40\% and 60\% of the original number of events have been accrued. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 10\%.
    \item The promising interval at IA2 ranges from 50\% to 90\%.
    \item The target conditional power at IA2 is set to 90\% and the target number of events could be increased up to 30\%.
}
The median event times, e.g., median survival times, are assumed to be 7.5 months and 10.5 months in the control and experimental treatment arms, respectively. If the time to the event of interest is exponentially distributed, these assumptions correspond to a hazard ratio of 0.71.

Key operating characteristics of this adaptive design will be evaluated using the \code{\link{ADSSMod}} function with 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADSSModApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADSSMod}}, \code{\link{ADSSModExample1}}, \code{\link{ADSSModExample2}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Time-to-event"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, treatment) 
parameters$sample_size = c(220, 220)

# Annual patient dropout rate
parameters$dropout_rate = 0.05

# Median time in the control arm 
parameters$control_time = 7.5

# Median time in the treatment arm 
parameters$treatment_time = 10.5

# Target event count at FA (before event count adjustment)
parameters$event_count = 300

# Information fractions at IA1, IA2, FA (before event count adjustment) 
# and FA (after event count adjustment)
parameters$info_frac = c(0.4, 0.6, 1, 1.3)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.1

# Promising interval for conditional power at IA2
parameters$promising_interval = c(0.5, 0.9)

# Target conditional power for increasing the number of events at IA2
parameters$target_power = 0.9

# Enrollment period
parameters$enrollment_period = 12

# Median enrollment time
parameters$enrollment_parameter = 8

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations
parameters$nsims = 1000

# Run simulations to compute operating characteristics
results = ADSSMod(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADSSMod Time-to-event endpoint.docx", fileext=".docx"))
}