% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClearText.R
\name{ClearText}
\alias{ClearText}
\title{Text Cleaning: Custom Method}
\usage{
ClearText(Text, CustomList = c(""))
}
\arguments{
\item{Text}{A String or Character vector, user-defined.}

\item{CustomList}{A Character vector (Optional), user-defined vector to
introduce stopwords ("english") in \code{Text}.}
}
\value{
Returns Character
}
\description{
Cleans text and introduce custom stopwords to remove unwanted
 words from given data.
}
\examples{
################### Methodology #####################
###### For DataFrame ######
#### Creates Dataset based on keysword
\donttest{
NewsData = TOI_News_Articles("Goibibo")

## Identify any potential factor columns
vc = sapply(NewsData, is.factor)

## Convert factors to characters
NewsData[vc] = lapply(NewsData[vc], as.character)

## Clean text on specific character columns
for (i in 1:nrow(NewsData)) NewsData$News[i] = ClearText(NewsData$News[i])
}
######## For Character Variable #### Ex2 ####

para = "Moreover, the text data we get is noisy. But, if we can learn some
methods useful to extract important features from the noisy data, wouldn't
scandal that be amazing ? In this tuto23rial, you'll saadc@ruby.com
learn #world all ab33out regu12lar expressions from scratch. At first, 32324
detective you might find these confusing, or complicated, but after
https://anaconda.com/anaconda-enters-new-chapter/ expressions tricky,
scooby-doo doing practical hands-on exercises (done below)
you should feel bcc: @MikeQuindazzi quite comfortable with it.
In addition, we'll also cartoon-network learn about string 121manipulation
functions in R. This formidable combination of #DL #4IR #Robots
#ArtificialIntelligence string manipulation functions and regular
expressions will prepare you for text mining."

clearpara = ClearText(para,
                       CustomList = c("scooby-doo",
                                      "cartoon-network",
                                       "detective",
                                       "scandal"))
########### For List #############
\donttest{
paraList = list(para, 1213, factor('aasd;kasdioasd'))
paraList = lapply(paraList, as.character)
for (x in 1:length(paraList)) paraList[[x]] = ClearText(paraList[[x]])
}
}
\seealso{
\code{\link{TOI_News_Articles}},  \code{\link{TOI_News_Dataset}}
}
\author{
Vatsal Aima,  \email{vaima75@hotmail.com}
}
