% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_filterDate.R
\name{sts_filterDate}
\alias{sts_filterDate}
\title{Date filtering for \emph{sts} time series objects}
\usage{
sts_filterDate(
  sts = NULL,
  startdate = NULL,
  enddate = NULL,
  timezone = NULL,
  unit = "sec",
  ceilingStart = FALSE,
  ceilingEnd = FALSE
)
}
\arguments{
\item{sts}{MazamaSingleTimeseries \emph{sts} object.}

\item{startdate}{Desired start datetime (ISO 8601).}

\item{enddate}{Desired end datetime (ISO 8601).}

\item{timezone}{Olson timezone used to interpret dates.}

\item{unit}{Units used to determine time at end-of-day.}

\item{ceilingStart}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{startdate} rather than
\code{\link[lubridate]{floor_date}}}

\item{ceilingEnd}{Logical instruction to apply
\code{\link[lubridate]{ceiling_date}} to the \code{enddate} rather than
\code{\link[lubridate]{floor_date}}}
}
\value{
A subset of the incoming \emph{sts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Subsets a MazamaSingleTimeseries object by date. This function
always filters to day-boundaries. For sub-day filtering, use
\code{sts_filterDatetime()}.

Dates can be anything that is understood by \code{MazamaCoreUtils::parseDatetime()}
including either of the following recommended formats:

\itemize{
\item{\code{"YYYYmmdd"}}
\item{\code{"YYYY-mm-dd"}}
}

Timezone determination precedence assumes that if you are passing in
\code{POSIXct} values then you know what you are doing.

\enumerate{
\item{get timezone from \code{startdate} if it is \code{POSIXct}}
\item{use passed in \code{timezone}}
\item{get timezone from \code{sts}}
}
}
\note{
The returned data will run from the beginning of \code{startdate} until
the \strong{beginning} of \code{enddate} -- \emph{i.e.} no values associated
with \code{enddate} will be returned. The exception being when
\code{enddate} is less than 24 hours after \code{startdate}. In that case, a
single day is returned.
}
\examples{
library(MazamaTimeSeries)

example_sts \%>\%
  sts_filterDate(startdate = 20180808, enddate = 20180815) \%>\%
  sts_extractData() \%>\%
  head()

}
\seealso{
\link{sts_filter}

\link{sts_filterDatetime}
}
