% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_US_countyCovid}
\alias{example_US_countyCovid}
\title{Example county Covid dataset}
\format{
A tibble with 52 rows and 3 columns of data.
}
\usage{
example_US_countyCovid
}
\description{
The \code{example_US_countyCovid} dataset provides a small
county dataset to use in code examples. The code for creating it demonstrates
creation of a dataest that is compatible with \code{countyMap()}.

This dataset was generated on 2020-06-12 by running:

\preformatted{
library(dplyr)
library(MazamaSpatialUtils)

fileUrl <- "https://raw.githubusercontent.com/nytimes/covid-19-data/master/us-counties.csv"

col_names <- c("date", "countyName", "stateName", "countyFIPS", "cases", "deaths")
col_types = "Dcccii"

outputColumns <- c("stateCode", "stateName", "countyFIPS", "countyName", "cases", "deaths")

# After a little trial and error, the following works well:

example_US_countyCovid <-
  readr::read_csv(
    file = fileUrl,
    skip = 1,                    # Skip the header line
    col_names = col_names,
    col_types = col_types
  ) \%>\%
  dplyr::mutate(
    stateCode = MazamaSpatialUtils::US_stateNameToCode(stateName),
  ) \%>\%
  dplyr::filter(.data$date == lubridate::ymd("2020-06-01")) \%>\%
  dplyr::select(!!outputColumns)

save(example_US_countyCovid, file = "data/example_US_countyCovid.rda")
}
}
\keyword{datasets}
