% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lib_iKernel.R
\name{get_inverse_GRAM}
\alias{get_inverse_GRAM}
\alias{check_positive_definite}
\title{The function to get inverse Gram matrix}
\usage{
get_inverse_GRAM(G, l = 1e-06, check_pos_def = FALSE)

check_positive_definite(G, n = 10)
}
\arguments{
\item{G}{Gram matrix gotten via \code{GRAM_iKernel()} function}

\item{l}{Lambda parameter or positive regularization constant}

\item{check_pos_def}{Logical parameter to check the Gram matrix is positive definite or do not check}

\item{n}{Number of iterations to check the positive definite property}
}
\value{
Function \code{get_inverse_GRAM()} returns the inverse Gram matrix
based on the given positive regularization constant lambda l

Function \code{check_positive_definite()} returns logical value: \cr
TRUE if Gram matrix is positive definite, and FALSE if it is not
}
\description{
Function \code{get_inverse_GRAM()} allows to get inverse Gram matrix based on given
positive regularization constant lambda

Function \code{check_positive_definite()} returns logical value about n trials on
'is Gram matrix positive definite or not?' Just incorrect trial returns FALSE
}
\section{Functions}{
\itemize{
\item \code{check_positive_definite()}: The function to check the positive definite property of Gram matrix

}}
\examples{
NULL
NULL
}
\keyword{internal}
