% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMSE.R
\name{Simulate}
\alias{Simulate}
\alias{Project}
\alias{runMSE}
\title{Run a Management Strategy Evaluation}
\usage{
Simulate(OM = MSEtool::testOM, parallel = FALSE, silent = FALSE)

Project(
  Hist = NULL,
  MPs = NA,
  parallel = FALSE,
  silent = FALSE,
  extended = FALSE,
  checkMPs = TRUE
)

runMSE(
  OM = MSEtool::testOM,
  MPs = NA,
  Hist = FALSE,
  silent = FALSE,
  parallel = FALSE,
  extended = FALSE,
  checkMPs = TRUE
)
}
\arguments{
\item{OM}{An operating model object (class \code{OM} or class \code{Hist})}

\item{parallel}{Logical. Should the MSE be run using parallel processing? Can be a vector of length(MPs)}

\item{silent}{Should messages be printed out to the console?}

\item{Hist}{Should model stop after historical simulations? Returns an object of
class 'Hist' containing all historical data}

\item{MPs}{A vector of methods (character string) of class MP}

\item{extended}{Logical. Return extended projection results?
if TRUE, \code{MSE@Misc$extended} is a named list with extended data
(including historical and projection by area), and extended version of \code{MSE@Hist}
is returned.}

\item{checkMPs}{Logical. Check if the specified MPs exist and can be run on \code{SimulatedData}?}
}
\value{
Functions return objects of class \linkS4class{Hist} or \linkS4class{MSE}
\itemize{
\item Simulate - An object of class \linkS4class{Hist}
\item Project - An object of class \linkS4class{MSE}
\item runMSE - An object of class \linkS4class{MSE}
}
}
\description{
Functions to run the Management Strategy Evaluation (closed-loop
simulation) for a specified operating model
}
\section{Functions}{
\itemize{
\item \code{Simulate}: Run the Historical Simulations from an object of class \code{OM}

\item \code{Project}: Run the Forward Projections

\item \code{runMSE}: Run the Historical Simulations and Forward Projections
from an object of class `OM
}}

