## ----set options, echo = FALSE,message=FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")
knitr::opts_chunk$set(dpi=85)
options(width = 650)

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  DLMtool::userguide()
#  DLMtool::cheatsheets()
#  
#  MSEtool::userguide()

## ---- eval = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  library(DLMtool)    # load DLMtool library
#  DLMextra()          # download lots of cool DLMtool/MSEtool objects from GitHub
#  library(DLMextra)   # load all those objects
#  library(MSEtool)    # load MSEtool (data rich MPs, MOM object class etc)
#  setup()             # set up a cluster for parallel processing

## ---- echo = FALSE, eval = TRUE, message = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(MSEtool)

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
slotNames('MOM')    # what slots are there in an MOM object
class?MOM           # check out the help file on MOM objects


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
avail('Stock')   # what Stock objects are loaded?
avail('Fleet')   # what Fleet objects are loaded?
avail('Obs')     # what Obs objects are loaded?
avail('Imp')     # what Imp objects are loaded?

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                 Stock 1    Stock 2
Stocks <- list(Bluefin_tuna, Herring)

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                           Fleet 1         Fleet 2      Fleet 3
Fleets_both_Stocks <- list(Generic_FlatE, Generic_IncE, Generic_DecE)  # for the sake of this exercise we assume identical fleet dynamics for both stocks
Fleets <- list( Fleets_both_Stocks, # Bluefin (position 1 in Stocks)
                Fleets_both_Stocks) # Herring (position 2 in Stocks)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                      Fleet 1             Fleet 2          Fleet 3
Bluefin_obs <- list(Precise_Unbiased, Precise_Unbiased, Precise_Unbiased)
Herring_obs <- list(Imprecise_Biased, Imprecise_Biased, Imprecise_Biased)
Obs <- list( Bluefin_obs,    # Bluefin (position 1 in Stocks)
             Herring_obs)    # Herring (position 2 in Stocks)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                        Fleet 1       Fleet 2     Fleet 3
Imp_both_Stocks <- list(Perfect_Imp, Perfect_Imp, Overages)
Imps <- list( Imp_both_Stocks,   # Bluefin (position 1 in Stocks)
              Imp_both_Stocks)   # Herring (position 2 in Stocks)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Bluefin_tuna@D
Herring@D

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
nsim = 4
#                  Fleet1  Fleet2   Fleet3
bluefin_catchfrac<-c(0.8,   0.01,   0.19)
herring_catchfrac<-c(0.05,  0.6,    0.35)
CatchFrac <- list(
                  matrix( rep(bluefin_catchfrac, each=nsim), nrow=nsim),
                  matrix( rep(herring_catchfrac, each=nsim), nrow=nsim)
)

CatchFrac[[1]]


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ages <- 1:60
bf_M <- mean(Bluefin_tuna@M)          # natural mortality rate
bf_Linf <- mean(Bluefin_tuna@Linf)    # asymptotic length
bf_K <- mean(Bluefin_tuna@K)          # von Bertalanffy growth parameter K
bf_t0 <- mean(Bluefin_tuna@t0)        # von B. theoretical age at length zero
bf_R0 <- Bluefin_tuna@R0              # unfished recruitment

bf_surv <- bf_R0*exp(-bf_M*(ages-1))             # survival
bf_wt_age <- bf_Linf*(1-exp(-bf_K*(ages-bf_t0))) # weight at age   
bf_unfished <- sum(bf_R0*bf_surv*bf_wt_age)      # approxiate estimate of unfished biomass

M_err <- rlnorm(100,0,0.05)
M_2 <- seq(0.2,0.4,length.out=100) * M_err  # made up herring (stock 2) M values
B_1 <- seq(0,bf_unfished,length.out=100)    # made up bluefin tuna abundance levels

dat <- data.frame(M_2,B_1)
bfB_hM <- lm(M_2~B_1,dat=dat) # a linear model predicting M for stock 2 from biomass B for stock 1
summary(bfB_hM)

Rel <- list(bfB_hM)

## ---- eval = TRUE, fig.width=6, fig.height=5----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
plot(dat$B_1, dat$M_2,pch=19, xlab = "Bluefin biomass", ylab = "Herring natural mortality")
lines(dat$B_1, predict(bfB_hM,newdat=dat), col = 'red', lwd = 2)
points(dat$B_1, simulate(bfB_hM,nsim=1,newdat=dat)[, 1], col = 'green')
legend('topleft',legend = c("made up data", "best fit", "simulated"), text.col = c('black','red','green'))

## ---- echo = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
MOM_BH <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, Rel=Rel, nsim=nsim)

## ---- eval = FALSE,  fig.width=9, fig.height=7--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  MOM_BH <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, Rel = Rel, nsim = nsim)
#  plot(MOM_BH)

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Stocks <-    list( Bluefin_tuna )
Fleets <-    list( list(Generic_FlatE, Generic_IncE, Generic_DecE) )
Obs <-       list( list(Precise_Unbiased, Precise_Unbiased, Precise_Unbiased) ) 
Imps <-      list( list(Perfect_Imp, Perfect_Imp, Overages) )
CatchFrac <- list( matrix( rep(c(0.8,   0.01,   0.19), each=nsim), nrow=nsim) )

MOM_1S <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, nsim=nsim)



## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                     Stock 1    Stock 2
Stocks <-    list( Bluefin_tuna, Herring )
#                         Bluefin                Herring            
Fleets <-    list(  list(Generic_FlatE),    list(Generic_FlatE)    )
Obs <-       list( list(Precise_Unbiased), list(Imprecise_Biased) )  
Imps <-      list(   list(Perfect_Imp),       list(Overages)      )

MOM_1F <- new('MOM', Stocks, Fleets, Obs, Imps, Rel = Rel, nsim=nsim)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                     Stock 1    Stock 2  Stock 3
Stocks <-    list( Bluefin_tuna, Herring, Mackerel )
#                         Bluefin fleet           Herring fleet       Mackerel fleet          
Fleets <-    list(  list(Generic_FlatE),    list(Generic_IncE),     list(Generic_DecE)    )
Obs <-       list( list(Precise_Unbiased), list(Imprecise_Biased),  list(Precise_Biased) )  
Imps <-      list(   list(Perfect_Imp),       list(Overages),       list(Overages)      )
CatchFrac <- list( matrix(1, nrow=nsim),   matrix(1, nrow=nsim),    matrix(1, nrow=nsim) )

MOM_FS <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, Rel = Rel, nsim=nsim)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

avail('MP')
MPs_c <- c("DCAC", "DBSRA", "DD")


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

MPs_bs<-list( c("DCAC", "DBSRA", "DD"),      # Stock 1
              c("DCAC", "DCAC",  "SPMSY") )  # Stock 2


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

MPs<-list( c("DCAC", "DBSRA","DCAC", "DBSRA"),   # Stock 1
           c("DCAC", "DCAC", "DBSRA","DBSRA") )  # Stock 2


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

myMPs <- c("DCAC", "DBSRA")
nstocks <- 5
MPs <- split(t(expand.grid(list(myMPs)[rep(1,nstocks)])), 1:nstocks)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                       Fleet 1             Fleet 2
#                     MP1      MP2          MP1    MP2
MPs_bf<-list( list(c("DCAC", "DBSRA"),  c("MCD", "AvC")),    # Stock 1
              list(c("CurE",  "DD"),    c("AvC","SPMSY")) )  # Stock 2


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

MPs_mmp <- c("MMP_1", "MMP_2", "MMP_3")


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

mydaft_MMP <- function(DataList, reps=1){
  
  nStocks <- length(DataList)        # First level is stocks
  nFleets <- length(DataList[[1]])   # Second level is fleets (same dimensions among stocks)
  
  RecList <- new('list')             # The hierarchical list we are going to put recommendations in
  
  for(ss in 1:nStocks){
    
    RecList[[ss]] <- new('list')     # List of recommendations by fleet within stock
     
    for(ff in 1:nFleets){
      
      Rec <- new("Rec")              # New blank recommendations object
      Rec@TAC <- apply(DataList[[ss]][[ff]]@Cat,1,mean, na.rm = T) # TAC is average historical catch
      RecList[[ss]][[ff]]<-Rec       # Store recommendations object in RecList
      
    }
    
  }
  
  RecList                            # Return the RecList

}

class(mydaft_MMP) <- 'MMP'           # Assign our new function the correct class


## ---- eval = FALSE, fig.width=9, fig.height=7---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  
#  MPs_BH <- list( c("DCAC", "DBSRA", "AvC", "MCD"),  # Bluefin
#                  c("DCAC", "DBSRA", "AvC", "MCD"))  # Herring
#  
#  MMSE_BH <- multiMSE(MOM_BH, MPs=MPs)
#  
#  plot(MMSE_BH)
#  

## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

class?MMSE


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

MaF<-MaM <- Mackerel        # Copy Mackerel dynamics to female and male objects
MaF@Name <- "Mackerel_Female"
MaM@Name <- "Mackerel_Male"
MaF@Linf <- MaM@Linf*1.2    # females grow to 20% higher asymptotic lengths
MaF@M    <- MaM@M*1.2       # female natural mortality rate is 20% higher
MaF@K    <- MaM@K*1.2       # female fish grow 20% faster

Stocks <- list(MaF,MaM)
Fleets <- list(list(Generic_DecE),list(Generic_DecE)) # A single fleet model
Obs    <- list(list(Perfect_Info),list(Perfect_Info))
Imps   <- list(list(Perfect_Imp),list(Perfect_Imp))

SexPars <- list()
SexPars$SSBfrom <- matrix(c(1,1,0,0),nrow=length(Stocks)) # Stock (Row) spawn from SSB contributed by Stock (Column)
SexPars$SSBfrom
MOMsex <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, nsim = nsim, SexPars = SexPars)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

SnF<-SnM <- Snapper        # Copy Mackerel dynamics to female and male objects
SnF@Name <- "Snapper_Female"
SnM@Name <- "Snapper_Male"
SnF@Linf <- SnM@Linf*1.1    # females grow to 10% higher asymptotic lengths

Stocks <- list(MaF, MaM, SnF, SnM)
SexPars$SSBfrom <- matrix(c(1,1,0,0,0,0,0,0,0,0,1,1,0,0,0,0),nrow=length(Stocks)) 
SexPars$SSBfrom


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Stocks <- list(MaF, MaM, SnF, SnM)
SexPars$SSBfrom <- matrix(c(1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1),nrow=length(Stocks)) 
SexPars$SSBfrom


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Stocks <- list(Bluefin_tuna, MaF, MaM, Herring)
SexPars$SSBfrom <- matrix(c(1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1),nrow=length(Stocks)) 
SexPars$SSBfrom


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

SexPars$SSBfrom <- matrix(c(1,0,0,0,0,1,1,0,0,0.1,0.1,0,0,0,0,1),nrow=length(Stocks)) 
SexPars$SSBfrom


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

H_1_2<-array(rep(c(0,0,0,0,0,0,0.05,0.1,0.2,0.35,0.65,0.8,0.9,1),each=nsim),c(nsim,14))
MOMsex@SexPars$Herm<-list(H_1_2=H_1_2)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

H_3_11<-array(rep(c(0,0,0,0,0,0,0.05,0.1,0.2,0.35,0.65,0.8,0.9,1),each=nsim),c(nsim,14))
MOMsex@SexPars$Herm<-list(H_1_2 = H_1_2, H_3_11 = H_3_11) 


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
nsim = 12
#                  Fleet1  Fleet2   Fleet3
bluefin_catchfrac<-c(0.8,   0.01,   0.19)
herring_catchfrac<-c(0.05,  0.6,    0.35)
CatchFrac <- list(
                  matrix( rep(bluefin_catchfrac, each=nsim), nrow=nsim),
                  matrix( rep(herring_catchfrac, each=nsim), nrow=nsim)
)

CatchFrac[[1]]


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                  Fleet1  Fleet2   Fleet3
bluefin_catchfrac<-c(0.8,   0.01,   0.19)
herring_catchfrac<-c(0.05,  0.6,    0.35)
CatchFrac <- list(
                  matrix( rep(bluefin_catchfrac, each=nsim), nrow=nsim),
                  matrix( rep(herring_catchfrac, each=nsim), nrow=nsim)
)

#                  Fleet1  Fleet2   Fleet3
bluefin_allocation<-c(0.4,   0.21,   0.39)
herring_allocation<-c(0.025,  0.6125,    0.3625)
Allocation <- list(
                  matrix( rep(bluefin_allocation, each=nsim), nrow=nsim),
                  matrix( rep(herring_allocation, each=nsim), nrow=nsim)
)

MOM_BH_A <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, Allocation=Allocation, nsim=nsim)


## ---- eval = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#                        Fleet1  Fleet2   Fleet3
bluefin_fleet_efforts <- c(1,    0.5,    0.0001)
herring_fleet_efforts <- c(1,     1,       1)

Efactor <- list(
                  matrix( rep(bluefin_fleet_efforts, each=nsim), nrow=nsim),
                  matrix( rep(herring_fleet_efforts, each=nsim), nrow=nsim)
)

MOM_BH_A <- new('MOM', Stocks, Fleets, Obs, Imps, CatchFrac, Efactor=Efactor, nsim=nsim)


