% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuartetTally.R
\name{quartetTableDominant}
\alias{quartetTableDominant}
\title{Produce table of dominant quartets, with estimates of internal edge lengths}
\usage{
quartetTableDominant(rqt, bigweights = "infinite")
}
\arguments{
\item{rqt}{a table, as produced by \code{quartetTableResolved} of size (n choose 4)x(n+3);}

\item{bigweights}{\code{"infinite"} or \code{"finite"}, to indicate whether the weight (internal edge length)
of a quartet for which only one
topology appears is given as \code{Inf} or a finite, but large, numerical value}
}
\value{
an (n choose 4)x(n+1) array with dominant quartet topology encoded by 1,1,-1,-1 in
taxon columns, with signs indicating cherries; the (n+1)th column \code{"weight"} contains the maximum likelihood estimates,
under MSC on a 4-taxon tree, of the quartets' central edge lengths, in coalescent units
}
\description{
Converts table of counts of resolved quartets on \code{n} taxa to show only dominant one, with
maximum likelihood estimate of internal edge weight under the MSC.
}
\details{
If \code{bigweights="finite"}, when for a set of 4 taxa the quartet counts are (m,0,0) then
the edge weight is computed as if the relative frequency of the dominant topology were m/(m+1).
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
RQT[1:6,]
DQT=quartetTableDominant(RQT)
DQT[1:6,]

}
\seealso{
\code{\link{quartetTable}}, \code{\link{quartetTableResolved}}
}
