% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{quartetCutTestInd}
\alias{quartetCutTestInd}
\title{Multiple independent hypothesis tests for quartet counts fitting the Cut model under the NMSC}
\usage{
quartetCutTestInd(
  rqt,
  lambda = 0,
  method = "MLest",
  smallcounts = "approximate",
  bootstraps = 10^4
)
}
\arguments{
\item{rqt}{table of resolved quartet counts, as produced by \code{quartetTableResolved}, or \code{quartetStarTestInd}}

\item{lambda}{power divergence statistic parameter (e.g., 0 for likelihood ratio statistic, 1 for Chi-squared statistic)}

\item{method}{\code{"MLest"}, \code{"conservative"}, or \code{"bootstrap"}; see \code{quartetCutTest} for explanation}

\item{smallcounts}{\code{"bootstrap"} or \code{"approximate"}, method of obtaining p-value when some counts are small, so
the chosen \code{method} is inappropriate}

\item{bootstraps}{number of samples for bootstrapping}
}
\value{
a copy of \code{rqt} with two columns appended: \code{"p_cut"} with p-values and \code{"cutindex"}
   giving index 1,2, or 3 of ML estimate of quartet tree of blobs (1 if 12|34, 2 if 13|24, 3 if 14|23)
   under Cut model.
}
\description{
Perform a hypothesis test for all quartet counts in an input table, as if the counts for different choices of 4 taxa
are independent.
}
\details{
This function assumes all quartets are resolved.  The test performed and the arguments
are described more fully in \code{quartetCutTest}.
}
\examples{
data(pTableYeastRokas)
pT=pTableYeastRokas[1:10,1:11]
pTable=quartetCutTestInd(pT)

}
\references{
\insertRef{ABMR24}{MSCquartets}
}
\seealso{
\code{\link{quartetCutTest}}, \code{\link{quartetTestPlot}}, \code{\link{quartetStarTestInd}}, \code{\link{quartetTableResolved}}
}
