% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emee.R
\name{emee}
\alias{emee}
\title{Estimates the causal excursion effect for binary outcome MRT}
\usage{
emee(
  data,
  id,
  outcome,
  treatment,
  rand_prob,
  moderator_formula,
  control_formula,
  availability = NULL,
  numerator_prob = NULL,
  start = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data set in long format.}

\item{id}{The subject id variable.}

\item{outcome}{The outcome variable.}

\item{treatment}{The binary treatment assignment variable.}

\item{rand_prob}{The randomization probability variable.}

\item{moderator_formula}{A formula for the moderator variables. This should
start with ~ followed by the moderator variables. When set to \code{~ 1}, a fully
marginal excursion effect (no moderators) is estimated.}

\item{control_formula}{A formula for the control variables. This should
start with ~ followed by the control variables. When set to \code{~ 1}, only an
intercept is included as the control variable.}

\item{availability}{The availability variable. Use the default value (\code{NULL})
if your MRT doesn't have availability considerations.}

\item{numerator_prob}{Either a number between 0 and 1, or a variable name for
a column in data. If you are not sure what this is, use the default value (\code{NULL}).}

\item{start}{A vector of the initial value of the estimators used in the numerical
solver. If using default value (\code{NULL}), a vector of 0 will be used internally.
If specifying a non-default value, this needs to be a numeric vector of length
(number of moderator variables including the intercept) +
(number of control variables including the intercept).}

\item{verbose}{If default (`TRUE`), additional messages will be printed
during data preprocessing.}
}
\value{
An object of type "emee_fit"
}
\description{
Returns the estimated causal excursion effect (on log relative risk scale) and the estimated standard error.
Small sample correction using the "Hat" matrix in the variance estimate is implemented.
All variables should correspond to columns in data and should not be in quotation marks.
}
\examples{

## estimating the fully marginal excursion effect by setting
## moderator_formula = ~ 1
emee(
    data = data_binary,
    id = userid,
    outcome = Y,
    treatment = A,
    rand_prob = rand_prob,
    moderator_formula = ~1,
    control_formula = ~ time_var1 + time_var2,
    availability = avail
)

## estimating the causal excursion effect moderated by time_var1
## by setting moderator_formula = ~ time_var1
emee(
    data = data_binary,
    id = userid,
    outcome = Y,
    treatment = A,
    rand_prob = rand_prob,
    moderator_formula = ~time_var1,
    control_formula = ~ time_var1 + time_var2,
    availability = avail
)
}
