% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateEvaluationDates.R
\name{CreateEvaluationDates}
\alias{CreateEvaluationDates}
\title{Create triangle evaluation dates}
\usage{
CreateEvaluationDates(OriginPeriod, DevelopmentLag)
}
\arguments{
\item{OriginPeriod}{A vector of interval objects}

\item{DevelopmentLag}{A vector of period objects}
}
\value{
A vector of intervals
}
\description{
Triangle evaluation dates are established by adding development lags to the starting point of the origin periods.
}
\examples{
\dontrun{
OriginStart = c(mdy("1/1/2000"), mdy("1/1/2000"), mdy("1/1/2001"))
OriginEnd = c(mdy("12/31/2000"), mdy("12/31/2000"), mdy("12/31/2001"))
OriginPeriod = CreateOriginPeriods(OriginStart, OriginEnd) 
DevelopmentLag = c(months(12), months(24), months(12))

EvaluationDates = CreateEvaluationDates(OriginPeriod, DevelopmentLag)
EvaluationDates
}

}
\seealso{
\code{\link{CreateDevelopmentLags}}, \code{\link{CreateOriginPeriods}}
}

