% Generated by roxygen2 (4.0.2): do not edit by hand
\name{segFracBSignal}
\alias{segFracBSignal}
\title{segmentation function for the allele B fraction}
\usage{
segFracBSignal(dataSetName, normalTumorArray, chromosome = 1:22,
  method = c("cghseg", "PELT"), Rho = NULL, Kmax = 10,
  listOfFiles = NULL, savePlot = TRUE, verbose = TRUE)
}
\arguments{
\item{dataSetName}{The name of the data-set folder (it must correspond to a folder name in rawData folder.).}

\item{normalTumorArray}{Only in the case of normal-tumor study. A csv file or a data.frame containing the mapping between normal and tumor files.
The first column contains the name of normal files and the second the names of associated tumor files.}

\item{chromosome}{A vector with the chromosomes to be segmented.}

\item{method}{method of segmentation, either "PELT" or "cghseg".}

\item{Rho}{For method="PELT", vector containing all the penalization values to test for the segmentation. If no values are provided, default values will be used.}

\item{Kmax}{For method="cghseg", maximal number of segments.}

\item{listOfFiles}{A vector containing the names of the files in dataSetName folder for which the allele B profile is segmented (default is all the files).}

\item{savePlot}{if TRUE, graphics of the segmented allele B profile will be saved in the figures/dataSetName/segmentation/fracB folder. (default=TRUE).}

\item{verbose}{if TRUE print some informations}
}
\value{
a data.frame where each row correspond to a different segment with columns :
\describe{
  \item{sampleNames}{The name of the signal.}
  \item{chromosome}{A vector of the same size as copynumber containing the chromosome number.}
  \item{chromStart}{The starting position of a segment.}
  \item{chromEnd}{The ending position of a segment.}
  \item{probes}{The number of probes in the segment.}
  \item{means}{Means of the segment.}
}
}
\description{
This function launches the segmentation of allele B fraction only for heterozygous SNPs.
}
\author{
Quentin Grimonprez
}

