% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ges.partial.SS.mix.R
\name{ges.partial.SS.mix}
\alias{ges.partial.SS.mix}
\title{Partial Generalized Eta-Squared for Mixed Design ANOVA from F}
\usage{
ges.partial.SS.mix(dfm, dfe, ssm, sss, sse, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{ssm}{sum of squares for the model/IV/between}

\item{sss}{sum of squares subject variance}

\item{sse}{sum of squares for the error/residual/within}

\item{Fvalue}{F statistic}

\item{a}{significance level}
}
\value{
Partial generalized eta-squared (GES) with associated confidence intervals
and relevant statistics.
\item{ges}{effect size}
\item{geslow}{lower level confidence interval for ges}
\item{geshigh}{upper level confidence interval for ges}
\item{dfm}{degrees of freedom for the model/IV/between}
\item{dfe}{degrees of freedom for the error/residual/within}
\item{F}{F-statistic}
\item{p}{p-value}
\item{estimate}{the generalized eta squared statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the F-statistic in APA style for markdown printing}
}
\description{
This function displays partial generalized eta-squared (GES) from ANOVA analyses
and its non-central confidence interval based on the F distribution.
This formula works for mixed designs.
}
\details{
To calculate partial generalized eta squared, first, the sum of
squares of the model, sum of squares of the subject
variance, sum of squares for the subject variance,
and the sum of squares for the error/residual/within are added together.
The sum of squares of the model is divided by this value.

partial ges = ssm / (ssm + sss + sse)

\href{https://www.aggieerin.com/shiny-server/tests/gesmixss.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "mix2_data" dataset, included
#in the MOTE library.

#Given previous research, we know that backward strength in free
#association tends to increase the ratings participants give when
#you ask them how many people out of 100 would say a word in
#response to a target word (like Family Feud). This result is
#tied to people’s overestimation of how well they think they know
#something, which is bad for studying. So, we gave people instructions
#on how to ignore the BSG.  Did it help? Is there an interaction
#between BSG and instructions given?

library(ez)
mix2_data$partno = 1:nrow(mix2_data)

library(reshape)
long_mix = melt(mix2_data, id = c("partno", "group"))

anova_model = ezANOVA(data = long_mix,
                      dv = value,
                      wid = partno,
                      between = group,
                      within = variable,
                      detailed = TRUE,
                      type = 3)

#You would calculate one partial GES value for each F-statistic.
#Here's an example for the interaction with typing in numbers.
ges.partial.SS.mix(dfm = 1, dfe = 156,
                   ssm = 71.07608,
                   sss = 30936.498,
                   sse = 8657.094,
                   Fvalue = 1.280784, a = .05)

#Here's an example for the interaction with code.
ges.partial.SS.mix(dfm = anova_model$ANOVA$DFn[4],
               dfe = anova_model$ANOVA$DFd[4],
               ssm = anova_model$ANOVA$SSn[4],
               sss = anova_model$ANOVA$SSd[1],
               sse = anova_model$ANOVA$SSd[4],
               Fvalue =  anova_model$ANOVA$F[4],
               a = .05)
}
\keyword{ANOVA}
\keyword{effect}
\keyword{ges,}
\keyword{size,}
