## MOSS: Multi-omic integration via sparse singular value decomposition.

[![CRAN status](https://www.r-pkg.org/badges/version/MOSS?color=orange)](https://CRAN.R-project.org/package=MOSS)
![Travis-CI Build Status](https://app.travis-ci.com/agugonrey/MOSS.svg?branch=master)
[![CRAN checks](https://cranchecks.info/badges/worst/MOSS)](https://cran.r-project.org/web/checks/check_results_MOSS.html)
![Downloads](http://cranlogs.r-pkg.org/badges/MOSS?color=blue) 
![Downloads](https://cranlogs.r-pkg.org/badges/grand-total/MOSS?color=blue)

Agustin Gonzalez-Reymundez, Alexander Grueneberg, and Ana I. Vazquez.

### Installing and loading MOSS from CRAN.

```
install.packages("MOSS")
library("MOSS")
```
### Installing and loading MOSS from GitHub.

```
if (require("remotes") == FALSE) install.packages("remotes")
install_github("agugonrey/MOSS")
library("MOSS")
```

### Article

[MOSS: Multi-omic integration with Sparse Value Decomposition](https://academic.oup.com/bioinformatics/advance-article/doi/10.1093/bioinformatics/btac179/6553658?login=true)


### Documentation.

  For a description of the package's main function. 

```
help(moss)
```

  For more documentation, see:

[supplementary information for Gonzalez-Reymundez et al (2022)](https://github.com/agugonrey/GonzalezReymundez2021)

and

[vignette](https://github.com/agugonrey/MOSS/blob/master/inst/MOSS_working_example.pdf). 
