% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_adj.R
\name{cov_adj}
\alias{cov_adj}
\title{Adjust omic blocks for covariates effects.}
\usage{
cov_adj(data.blocks, covs, n, dim.names = NULL)
}
\arguments{
\item{data.blocks}{List containing omic blocks of class 'matrix' or
'FBM'. In each block, rows represent subjects and columns features.}

\item{covs}{Covariates which effect we wish to adjust for. 
Accepts objects of class matrix, data.frame, numeric, or 
character vectors.}

\item{n}{Number of subjects. Numeric.}

\item{dim.names}{list of vectors with samples names, and features names
by omic block. If NULL, a list of artificial names is created.
Defaults to NULL.}
}
\value{
Returns the covariates-adjusted elements in data.blocks.
}
\description{
This function is called by moss to adjust a series of omic 
blocks for covariates effects.
}
\examples{
library("MOSS")
sim_data <- simulate_data()
set.seed(43)

# Extracting simulated omic blocks.
sim_blocks <- sim_data$sim_blocks[-4]

# Using fourth block as covariates.
covs <- sim_data$sim_blocks[[4]]

# Adjust omic blocks for covariates effects.
sim_blocks_adj <- cov_adj(sim_blocks,covs,nrow(covs))
}
